/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.actions;

import com.valeras.colorwheel_harmony.actions.AbstractApplicationAction;
import com.valeras.colorwheel_harmony.app_core.StringTable;
import com.valeras.colorwheel_harmony.app_core.print.PrintManager;
import java.awt.event.ActionEvent;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.print.attribute.PrintRequestAttributeSet;

public class FilePrintAction
extends AbstractApplicationAction {
    private static final String STR_PRINTING = "print.job.name.printing";

    public FilePrintAction() {
        super(FilePrintAction.getString("action.file.print"), "action.file.print");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        PrintManager l_printManager = this.getPrintManager();
        PrinterJob l_printerJob = l_printManager.getPrinterJob();
        l_printerJob.setJobName(application.getTitle() + StringTable.get(STR_PRINTING));
        PrintRequestAttributeSet l_printAttributes = l_printManager.getPrintRequestAttributeSet();
        boolean l_doPrint = l_printerJob.printDialog(l_printAttributes);
        if (l_doPrint) {
            PageFormat l_pageFormat = l_printerJob.getPageFormat(l_printAttributes);
            l_printManager.setPageFormat(l_pageFormat);
            l_printerJob.setPrintable(l_printManager.getPrintable(), l_pageFormat);
            try {
                l_printerJob.print();
            }
            catch (PrinterException ex) {
                Logger.getLogger(FilePrintAction.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

