/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.actions;

import com.valeras.colorwheel_harmony.actions.AbstractFileAction;
import com.valeras.colorwheel_harmony.app_core.StringTable;
import com.valeras.colorwheel_harmony.document.AbstractColorDocument;
import com.valeras.mdi.FileFormat;
import java.awt.event.ActionEvent;
import java.io.File;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileOpenAction
extends AbstractFileAction {
    private static final String MSG_OPEN_FAILED = "application.message.failed_open_file";

    public FileOpenAction() {
        super(FileOpenAction.getString("action.file.open"), "action.file.open");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        File l_file;
        AbstractColorDocument l_document = null;
        if (!documentManager.isMultipleDocumentManager()) {
            l_document = (AbstractColorDocument)documentManager.getSelectedDocument();
            if (l_document != null && l_document.isChanged()) {
                int l_option = this.showConfirmDialog(MessageFormat.format(StringTable.get("application.message.save_changed_file"), l_document.getName()), "", 1);
                if (l_option == 0) {
                    this.performSave(l_document);
                } else if (l_option == 2) {
                    return;
                }
            }
            l_document = null;
        }
        if ((l_file = FileOpenAction.showOpenDialog(null)) == null) {
            return;
        }
        FileFormat l_format = documentManager.getFileType(l_file).getFileFormat(l_file);
        l_document = (AbstractColorDocument)documentManager.getDocumentFactory().createDocument(l_format);
        try {
            documentManager.fileOpen(l_file, l_document, false);
        }
        catch (Exception ex) {
            Logger.getLogger(FileOpenAction.class.getName()).log(Level.SEVERE, null, ex);
            this.showErrorDialog(StringTable.get(MSG_OPEN_FAILED), null);
        }
        documentManager.add(l_document);
        documentManager.setSelectedDocument(l_document);
    }
}

