/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.actions;

import com.valeras.colorwheel_harmony.actions.AbstractFileAction;
import com.valeras.colorwheel_harmony.app_core.StringTable;
import com.valeras.colorwheel_harmony.document.AbstractColorDocument;
import java.awt.event.ActionEvent;
import java.io.File;
import java.text.MessageFormat;

public class FileNewAction
extends AbstractFileAction {
    private static final String MSG_SAVE_CHANGES = "application.message.save_changed_file";

    public FileNewAction() {
        super(FileNewAction.getString("action.file.new"), "action.file.new");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        AbstractColorDocument l_document;
        if (!documentManager.isMultipleDocumentManager() && (l_document = (AbstractColorDocument)documentManager.getSelectedDocument()) != null && l_document.isChanged()) {
            int l_option = this.showConfirmDialog(MessageFormat.format(StringTable.get(MSG_SAVE_CHANGES), l_document.getName()), FileNewAction.getString("action.file.new"), 1);
            switch (l_option) {
                case 0: {
                    File l_file = l_document.getFile();
                    if (l_file != null) {
                        this.performSave(l_document, l_file);
                        break;
                    }
                    this.performSaveAs(l_document, null);
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    return;
                }
            }
        }
        l_document = (AbstractColorDocument)documentManager.fileNew();
        documentManager.add(l_document);
        documentManager.setSelectedDocument(l_document);
    }
}

