/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.actions;

import com.valeras.colorwheel_harmony.actions.AbstractApplicationAction;
import com.valeras.colorwheel_harmony.actions.image_io.ImageHelper;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.SwingWorker;
import javax.swing.filechooser.FileFilter;

public class FileLoadImageAction
extends AbstractApplicationAction {
    private static final String STR_TITLE = "dialog.load_image.title";
    private static final String STR_COMPOSITE_FILTER = "dialog.load_image.composite_filter";
    private static final String STR_LOADING = "action.file.load_image.msg.loading";

    public FileLoadImageAction() {
        super(FileLoadImageAction.getString("action.file.load_image"), "action.file.load_image");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JFileChooser l_fc = new JFileChooser();
        FileFilter[] l_filters = ImageHelper.getImageFileFilterList();
        FileFilter l_filter = this.createCompositeFileFilter(l_filters, FileLoadImageAction.getString(STR_COMPOSITE_FILTER));
        l_fc.addChoosableFileFilter(l_filter);
        for (FileFilter f : l_filters) {
            l_fc.addChoosableFileFilter(f);
        }
        l_fc.setFileFilter(l_filter);
        l_fc.setDialogTitle(FileLoadImageAction.getString(STR_TITLE));
        if (l_fc.showOpenDialog(this.getMainWindow()) != 0) {
            return;
        }
        File l_file = l_fc.getSelectedFile();
        LoadImageSwingWorker l_task = new LoadImageSwingWorker(l_file);
        this.showProgressMessage(FileLoadImageAction.getString(STR_LOADING), null);
        l_task.execute();
    }

    private class LoadImageSwingWorker
    extends SwingWorker<BufferedImage, Object> {
        private final File file;
        private String errMessage;

        public LoadImageSwingWorker(File file) {
            this.file = file;
            this.errMessage = null;
        }

        @Override
        protected BufferedImage doInBackground() throws Exception {
            BufferedImage l_image = null;
            try {
                l_image = ImageIO.read(this.file);
            }
            catch (IOException ex) {
                Logger.getLogger(FileLoadImageAction.class.getName()).log(Level.SEVERE, null, ex);
                this.errMessage = ex.getMessage();
            }
            return l_image;
        }

        @Override
        protected void done() {
            BufferedImage l_image;
            FileLoadImageAction.this.hideProgressMessage();
            try {
                l_image = (BufferedImage)this.get();
            }
            catch (Exception ex) {
                FileLoadImageAction.this.showErrorDialog(ex.getMessage(), AbstractApplicationAction.getString(FileLoadImageAction.STR_TITLE));
                return;
            }
            if (l_image == null) {
                FileLoadImageAction.this.showErrorDialog(this.errMessage, AbstractApplicationAction.getString(FileLoadImageAction.STR_TITLE));
                return;
            }
            FileLoadImageAction.this.getColorCombineToolkit().setImage(l_image, this.file);
            FileLoadImageAction.this.getMainWindow().selectColorTool("mode.color_picker");
        }
    }
}

