/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.actions;

import com.valeras.color_chart.ColorChart;
import com.valeras.color_chart.reader.ColorChartReader;
import com.valeras.colorwheel_harmony.actions.AbstractApplicationAction;
import com.valeras.colorwheel_harmony.app_core.features.ColorChartsFeature;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.SwingWorker;
import javax.swing.filechooser.FileFilter;

public class FileLoadColorChartAction
extends AbstractApplicationAction {
    private static final String STR_TITLE = "dialog.load_color_chart.title";
    private static final String STR_COMPOSITE_FILTER = "dialog.load_color_chart.composite_filter";
    private static final String STR_NO_READER = "dialog.load_color_chart.no_reader";
    private static final String STR_LOADING = "dialog.load_color_chart.loading";
    private final ColorChartsFeature feature = (ColorChartsFeature)application.getFeature("feature.color_charts");

    public FileLoadColorChartAction() {
        super(FileLoadColorChartAction.getString("action.file.load_color_chart"), "action.file.load_color_chart");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JFileChooser l_fc = new JFileChooser();
        Collection<FileFilter> l_filters = this.feature.getFileFilters();
        FileFilter[] l_filterArray = new FileFilter[l_filters.size()];
        FileFilter l_filter = this.createCompositeFileFilter(l_filters.toArray(l_filterArray), FileLoadColorChartAction.getString(STR_COMPOSITE_FILTER));
        l_fc.addChoosableFileFilter(l_filter);
        for (FileFilter f : l_filters) {
            l_fc.addChoosableFileFilter(f);
        }
        l_fc.setFileFilter(l_filter);
        l_fc.setDialogTitle(FileLoadColorChartAction.getString(STR_TITLE));
        if (l_fc.showOpenDialog(this.getMainWindow()) != 0) {
            return;
        }
        File l_file = l_fc.getSelectedFile();
        ColorChartReader l_reader = this.feature.readerFor(l_file);
        if (l_reader == null) {
            this.showWarningDialog(FileLoadColorChartAction.getString(STR_NO_READER), null);
            return;
        }
        this.showProgressMessage(FileLoadColorChartAction.getString(STR_LOADING), null);
        LoadColorChartSwingWorker l_task = new LoadColorChartSwingWorker(l_file, l_reader);
        l_task.execute();
    }

    private class LoadColorChartSwingWorker
    extends SwingWorker<ColorChart, Object> {
        private final File file;
        private final ColorChartReader reader;
        private String errMessage;

        public LoadColorChartSwingWorker(File file, ColorChartReader reader) {
            this.file = file;
            this.reader = reader;
            this.errMessage = null;
        }

        @Override
        protected ColorChart doInBackground() throws Exception {
            FileInputStream l_stream;
            ColorChart l_colorChart = FileLoadColorChartAction.this.feature.createColorChart();
            try {
                l_stream = new FileInputStream(this.file);
            }
            catch (FileNotFoundException ex) {
                Logger.getLogger(FileLoadColorChartAction.class.getName()).log(Level.SEVERE, null, ex);
                this.errMessage = ex.getMessage();
                return null;
            }
            try {
                this.reader.read((InputStream)l_stream, l_colorChart);
            }
            catch (Exception ex) {
                Logger.getLogger(FileLoadColorChartAction.class.getName()).log(Level.SEVERE, null, ex);
                this.errMessage = ex.getMessage();
            }
            try {
                ((InputStream)l_stream).close();
            }
            catch (IOException ex) {
                Logger.getLogger(FileLoadColorChartAction.class.getName()).log(Level.SEVERE, null, ex);
            }
            return l_colorChart;
        }

        @Override
        protected void done() {
            ColorChart l_colorChart;
            FileLoadColorChartAction.this.hideProgressMessage();
            try {
                l_colorChart = (ColorChart)this.get();
            }
            catch (Exception ex) {
                FileLoadColorChartAction.this.showErrorDialog(ex.getMessage(), AbstractApplicationAction.getString(FileLoadColorChartAction.STR_TITLE));
                return;
            }
            if (l_colorChart == null) {
                FileLoadColorChartAction.this.showErrorDialog(this.errMessage, AbstractApplicationAction.getString(FileLoadColorChartAction.STR_TITLE));
                return;
            }
            FileLoadColorChartAction.this.feature.addColorChart(l_colorChart, true);
        }
    }
}

