/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.actions;

import com.valeras.colorwheel_harmony.actions.AbstractFileAction;
import com.valeras.colorwheel_harmony.app_core.StringTable;
import com.valeras.colorwheel_harmony.document.AbstractColorDocument;
import com.valeras.colorwheel_harmony.document.SupportedFileFormats;
import com.valeras.colorwheel_harmony.document.io.chp.CHPDocument;
import com.valeras.mdi.FileFormat;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class FileImportAction
extends AbstractFileAction {
    private static final String MSG_IMPORT_FAILED = "application.message.failed_import_file";

    public FileImportAction() {
        super(FileImportAction.getString("action.file.import"), "action.file.import");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        AbstractColorDocument l_document = null;
        File l_file = FileImportAction.showImportDialog(null);
        if (l_file == null) {
            return;
        }
        FileFormat l_format = documentManager.getFileType(l_file).getFileFormat(l_file);
        l_document = (AbstractColorDocument)documentManager.getDocumentFactory().createDocument(l_format);
        try {
            documentManager.fileOpen(l_file, l_document, true);
        }
        catch (Exception ex) {
            Logger.getLogger(FileImportAction.class.getName()).log(Level.SEVERE, null, ex);
            this.showErrorDialog(StringTable.get(MSG_IMPORT_FAILED), null);
        }
        this.doImport((CHPDocument)documentManager.getSelectedDocument(), l_document);
    }

    protected void doImport(CHPDocument document, AbstractColorDocument importee) {
        if (importee.isColorPaletteSupported()) {
            document.setColorPalette(importee.getColorPalette());
        }
    }

    public static File showImportDialog(File folder) {
        JFileChooser l_fc = new JFileChooser();
        FileFormat[] l_supportedFileFormats = new FileFormat[]{SupportedFileFormats.GIMP_GPL_FILE_FORMAT, SupportedFileFormats.PAINTNET_TXT_FILE_FORMAT};
        FileFilter l_supportedFilesFilter = FileFormat.createCompositeFileFilter(l_supportedFileFormats, FileImportAction.getString("file_chooser.supported_files.description"));
        FileFilter[] l_fileFilters = FileFormat.createChoosableFileFilters(l_supportedFileFormats);
        l_fc.addChoosableFileFilter(l_supportedFilesFilter);
        for (FileFilter ff : l_fileFilters) {
            l_fc.addChoosableFileFilter(ff);
        }
        l_fc.setFileFilter(l_supportedFilesFilter);
        l_fc.setCurrentDirectory(folder);
        l_fc.showOpenDialog(application.getMainWindow());
        File l_file = l_fc.getSelectedFile();
        return l_file;
    }
}

