/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.actions;

import com.valeras.colorwheel_harmony.actions.AbstractFileAction;
import com.valeras.colorwheel_harmony.actions.FileImportAction;
import com.valeras.colorwheel_harmony.app_core.StringTable;
import com.valeras.colorwheel_harmony.document.AbstractColorDocument;
import com.valeras.colorwheel_harmony.document.SupportedFileFormats;
import com.valeras.mdi.FileFormat;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;

public class FileExportAction
extends AbstractFileAction {
    private static final String MSG_EXPORT_FAILED = "application.message.failed_export_file";

    public FileExportAction() {
        super(FileExportAction.getString("action.file.export"), "action.file.export");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        AbstractColorDocument l_document = null;
        File l_file = FileExportAction.showExportDialog(null);
        if (l_file == null) {
            return;
        }
        FileFormat l_format = documentManager.getFileType(l_file).getFileFormat(l_file);
        l_document = (AbstractColorDocument)documentManager.getDocumentFactory().createDocument(l_format);
        this.doExport((AbstractColorDocument)documentManager.getSelectedDocument(), l_document);
        try {
            documentManager.fileSave(l_document, l_file, l_format);
        }
        catch (Exception ex) {
            Logger.getLogger(FileImportAction.class.getName()).log(Level.SEVERE, null, ex);
            this.showErrorDialog(StringTable.get(MSG_EXPORT_FAILED), null);
        }
    }

    protected void doExport(AbstractColorDocument source, AbstractColorDocument target) {
        target.setName(source.getName());
        if (source.isColorPaletteSupported() && target.isColorPaletteSupported()) {
            target.setColorPalette(source.getColorPalette());
        }
    }

    public static File showExportDialog(File folder) {
        FileFilter[] l_fileFilters;
        File l_file = null;
        JFileChooser l_fc = new JFileChooser();
        FileFormat[] l_supportedFileFormats = new FileFormat[]{SupportedFileFormats.GIMP_GPL_FILE_FORMAT, SupportedFileFormats.PAINTNET_TXT_FILE_FORMAT};
        for (FileFilter ff : l_fileFilters = FileFormat.createChoosableFileFilters(l_supportedFileFormats)) {
            l_fc.addChoosableFileFilter(ff);
        }
        l_fc.setFileFilter(l_fileFilters[0]);
        l_fc.setCurrentDirectory(folder);
        if (l_fc.showSaveDialog(application.getMainWindow()) == 0) {
            l_file = l_fc.getSelectedFile();
            String l_name = l_file.getName();
            FileFilter l_filter = l_fc.getFileFilter();
            String l_suffix = ((FileNameExtensionFilter)l_filter).getExtensions()[0].toLowerCase();
            if (!l_name.toLowerCase().endsWith(l_suffix)) {
                l_name = l_name + "." + l_suffix;
                l_file = new File(l_file.getParent(), l_name);
            }
        }
        return l_file;
    }
}

