/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.actions;

import com.valeras.color_chart.ColorChart;
import com.valeras.color_chart.ColorChartEntry;
import com.valeras.colorwheel_harmony.actions.AbstractApplicationAction;
import com.valeras.colorwheel_harmony.model.ColorDetails;
import java.awt.Color;
import java.awt.color.ColorSpace;
import java.awt.event.ActionEvent;
import javax.swing.JOptionPane;

public class EditEnterColorCodeAction
extends AbstractApplicationAction {
    public static final String ACTION_NAME = "action.edit.enter_color_code";
    private static final String STR_MESSAGE = "Enter either color chart code\nor hexadecimal sRGB value:";
    private static final String MSG_WRONG_INPUT = "Failed to recognize color code.";

    public EditEnterColorCodeAction() {
        super(EditEnterColorCodeAction.getString(ACTION_NAME), ACTION_NAME);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Color l_color = this.colorCombineToolkit.getSelectedColor();
        ColorDetails l_details = l_color != null ? ColorDetails.getDetails(l_color) : null;
        ColorSpace l_cs = this.colorCombineToolkit.getColorMatchingColorSpace();
        String l_text = l_details != null ? l_details.getCode() : "";
        l_text = JOptionPane.showInputDialog(application.getMainWindow(), STR_MESSAGE, l_text);
        if (l_text != null) {
            ColorChart l_chart;
            ColorChartEntry l_entry;
            l_text = l_text.trim();
            l_color = null;
            if (l_cs != null && l_cs instanceof ColorChart && (l_entry = (l_chart = (ColorChart)l_cs).getEntry(l_text)) != null) {
                l_color = l_chart.getColor(l_chart.getEntryIdentifier(l_entry));
            }
            if (l_color == null) {
                try {
                    int l_rgb = Integer.parseInt(l_text, 16);
                    l_color = new Color(l_rgb);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (l_color != null) {
                this.colorCombineToolkit.setSelectedColor(l_color);
            } else {
                this.showErrorDialog(MSG_WRONG_INPUT, null);
            }
        }
    }
}

