/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.actions;

import com.valeras.colorwheel_harmony.actions.AbstractFileAction;
import com.valeras.colorwheel_harmony.model.ColorSpaceProvider;
import com.valeras.colorwheel_harmony.ui.model.ColorPickerModel;
import com.valeras.colorwheel_harmony.ui.swing.panels.ColorComponentEditPanel;
import java.awt.Color;
import java.awt.color.ColorSpace;
import java.awt.event.ActionEvent;
import javax.swing.JOptionPane;

public class EditColorComponentsAction
extends AbstractFileAction {
    private static final String STR_DIALOG_TITLE = "dialog.edit_color.title";
    private static final String ACTION_NAME = "action.edit.color_components";

    public EditColorComponentsAction() {
        super(EditColorComponentsAction.getString(ACTION_NAME), "action.edit.color");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ColorSpaceProvider l_csp = ColorSpaceProvider.getInstance();
        Color l_color = this.colorCombineToolkit.getSelectedColor();
        if (l_color == null) {
            l_color = Color.white;
        }
        ColorSpace l_Lab = l_csp.provide("CS_CIELab");
        ColorSpace l_CMYK = l_csp.provide("CS_CMYK");
        ColorPickerModel l_model = new ColorPickerModel(l_Lab, l_CMYK, l_csp.getProfileName(l_csp.getCMYKProfile()));
        l_model.setRGB(l_color.getRGB());
        ColorComponentEditPanel l_panel = new ColorComponentEditPanel(l_model);
        int l_option = JOptionPane.showConfirmDialog(application.getMainWindow(), l_panel, EditColorComponentsAction.getString(STR_DIALOG_TITLE), 2, -1);
        if (l_option == 0 && (l_color = new Color(l_model.getRGB())) != null) {
            this.colorCombineToolkit.setSelectedColor(l_color);
        }
    }
}

