/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.actions;

import com.valeras.colorwheel_harmony.actions.AbstractApplicationAction;
import com.valeras.colorwheel_harmony.document.AbstractColorDocument;
import com.valeras.mdi.FileFormat;
import com.valeras.mdi.FileType;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;

public abstract class AbstractFileAction
extends AbstractApplicationAction {
    private static final String MSG_WRITE_FAILED = "application.message.failed_save_file";
    private static final String MSG_OVERWRITE_EXISTING = "File already exists.\nDo you want to overwrite it?";
    private static final String MSG_CANT_WRITE = "The selected file cannot be written.";
    protected static final String STR_SUPPORTED_FILES_DESCRIPTION = "file_chooser.supported_files.description";
    private String actionName;

    public AbstractFileAction(String action, String command) {
        super(action, command);
        this.actionName = action;
    }

    protected void performOpen() {
    }

    protected void performSave(AbstractColorDocument document) {
        this.performSave(document, document.getFile());
    }

    protected void performSave(AbstractColorDocument document, File file) {
        try {
            documentManager.fileSave(document, file, document.getFileFormat());
            document.setChanged(false);
        }
        catch (IOException ex) {
            Logger.getLogger(AbstractFileAction.class.getName()).log(Level.SEVERE, null, ex);
            this.showErrorDialog(AbstractFileAction.getString(MSG_WRITE_FAILED), this.actionName);
        }
    }

    protected void performSaveAs(AbstractColorDocument document, File file) {
        String l_suffix = document.getFileFormat().getExtension();
        File l_file = file == null ? new File(document.getName() + "." + l_suffix) : file;
        if ((l_file = AbstractFileAction.showSaveDialog(l_file)) == null) {
            return;
        }
        if (l_file.exists()) {
            if (!l_file.canWrite()) {
                this.showErrorDialog(MSG_CANT_WRITE, this.actionName);
                return;
            }
            if (!this.showConfirmDialog(MSG_OVERWRITE_EXISTING, this.actionName)) {
                return;
            }
        }
        if (!l_file.equals(file)) {
            document.setName(this.getBareFileName(l_file, l_suffix));
        }
        document.setFile(l_file);
        FileFormat l_format = document.getFileFormat();
        try {
            documentManager.fileSave(document, l_file, l_format);
            document.setChanged(false);
        }
        catch (IOException ex) {
            Logger.getLogger(AbstractFileAction.class.getName()).log(Level.SEVERE, null, ex);
            this.showErrorDialog(AbstractFileAction.getString(MSG_WRITE_FAILED), this.actionName);
        }
    }

    protected String getBareFileName(File file, String suffix) {
        String l_name = file.getName();
        if (l_name.endsWith(suffix)) {
            l_name = l_name.substring(0, l_name.length() - suffix.length() - 1);
        }
        return l_name;
    }

    protected void performClose() {
    }

    public static File showOpenDialog(File folder) {
        JFileChooser l_fc = new JFileChooser();
        FileType[] l_supportedFileTypes = documentManager.getSupportedFileTypes();
        FileFilter l_supportedFilesFilter = FileType.createCompositeFileFilter(l_supportedFileTypes, AbstractFileAction.getString(STR_SUPPORTED_FILES_DESCRIPTION));
        FileFilter[] l_fileFilters = FileType.createChoosableFileFilters(l_supportedFileTypes);
        l_fc.addChoosableFileFilter(l_supportedFilesFilter);
        for (FileFilter ff : l_fileFilters) {
            l_fc.addChoosableFileFilter(ff);
        }
        l_fc.setFileFilter(l_fileFilters[0]);
        l_fc.setCurrentDirectory(folder);
        l_fc.showOpenDialog(application.getMainWindow());
        File l_file = l_fc.getSelectedFile();
        return l_file;
    }

    public static File showSaveDialog(File file) {
        JFileChooser l_fc = new JFileChooser();
        File l_file = null;
        FileFilter l_filter = ((AbstractColorDocument)documentManager.getSelectedDocument()).getFileFormat().createFileFilter();
        l_fc.setFileFilter(l_filter);
        if (file != null) {
            l_fc.setCurrentDirectory(file.getParentFile());
            l_fc.setSelectedFile(file);
        }
        if (l_fc.showSaveDialog(application.getMainWindow()) == 0) {
            l_file = l_fc.getSelectedFile();
            String l_name = l_file.getName();
            l_filter = l_fc.getFileFilter();
            String l_suffix = ((FileNameExtensionFilter)l_filter).getExtensions()[0].toLowerCase();
            if (!l_name.toLowerCase().endsWith(l_suffix)) {
                l_name = l_name + "." + l_suffix;
            }
            l_file = new File(l_file.getParent(), l_name);
        }
        return l_file;
    }
}

