/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.actions;

import com.valeras.colorwheel_harmony.actions.ActionClipboard;
import com.valeras.colorwheel_harmony.actions.FileLoadImageAction;
import com.valeras.colorwheel_harmony.actions.image_io.ImageHelper;
import com.valeras.colorwheel_harmony.app_core.AbstractColorWheelApplication;
import com.valeras.colorwheel_harmony.app_core.ApplicationSettings;
import com.valeras.colorwheel_harmony.app_core.StringTable;
import com.valeras.colorwheel_harmony.app_core.print.PrintManager;
import com.valeras.colorwheel_harmony.document.AbstractColorDocument;
import com.valeras.colorwheel_harmony.model.ColorCombineToolkit;
import com.valeras.colorwheel_harmony.ui.ApplicationMainWindow;
import com.valeras.colorwheel_harmony.ui.StatusBar;
import com.valeras.colorwheel_harmony.ui.swing.AbstractApplicationIconFactory;
import com.valeras.mdi.AbstractDocumentManager;
import java.awt.Desktop;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.BoundedRangeModel;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;

public abstract class AbstractApplicationAction
extends AbstractAction {
    private static final String DIALOG_CONFIRM_PREFIX = "Confirm ";
    public static final String MSG_DESKTOP_NOT_SUPPORTED = "application.message.browser_not_supported";
    public static final String MSG_DESKTOP_FAILED = "application.message.browser_failed";
    protected static final String MSG_FILE_WRITE_FAILED = "Failed to write file.";
    protected static final String MSG_FILE_OVERWRITE_EXISTING = "application.msg.file.overwrite_existing";
    protected static final String STR_WRITE_IMAGE_TITLE = "application.write_image";
    protected static final String MSG_FILE_CANNOT_WRITE = "Selected file cannot be written.";
    protected static AbstractColorWheelApplication application;
    protected static AbstractDocumentManager<AbstractColorDocument> documentManager;
    protected static ApplicationSettings settings;
    private static ActionClipboard clipboard;
    protected ColorCombineToolkit colorCombineToolkit;

    protected AbstractApplicationAction(String name, String command) {
        super(name);
        settings = application.getSettings();
        this.colorCombineToolkit = application.getColorCombineToolkit();
        this.putValue("ActionCommandKey", command);
        this.putValue("SmallIcon", this.getSmallIcon(command));
    }

    public String getCommand() {
        return (String)this.getValue("ActionCommandKey");
    }

    public static void setApplication(AbstractColorWheelApplication application) {
        AbstractApplicationAction.application = application;
        documentManager = application.getDocumentManager();
    }

    protected void putClipboard(Object object) {
        clipboard.setObject(object);
    }

    protected Object getClipboard() {
        return clipboard.getObject();
    }

    protected static void putSystemClipboard(String str) {
        Clipboard l_clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        if (l_clipboard != null) {
            StringSelection l_tr = new StringSelection(str);
            l_clipboard.setContents(l_tr, l_tr);
        }
    }

    protected ApplicationMainWindow getMainWindow() {
        return application.getMainWindow();
    }

    protected AbstractColorDocument getSelectedDocument() {
        return documentManager.getSelectedDocument();
    }

    protected PrintManager getPrintManager() {
        return PrintManager.getInstance();
    }

    protected ColorCombineToolkit getColorCombineToolkit() {
        return this.colorCombineToolkit;
    }

    protected void showErrorDialog(String message, String title) {
        JOptionPane.showMessageDialog(application.getMainWindow(), message, title != null ? title : application.getTitle(), 0);
    }

    protected void showWarningDialog(String message, String title) {
        JOptionPane.showMessageDialog(application.getMainWindow(), message, title != null ? title : application.getTitle(), 2);
    }

    protected void showInformationDialog(String message, String title) {
        JOptionPane.showMessageDialog(application.getMainWindow(), message, title != null ? title : application.getTitle(), 1);
    }

    protected boolean showConfirmDialog(String message, String title) {
        int l_option = JOptionPane.showConfirmDialog(application.getMainWindow(), message, "Confirm  " + title, 2, 3);
        return l_option == 0;
    }

    protected int showConfirmDialog(String message, String title, int optionType) {
        return JOptionPane.showConfirmDialog(application.getMainWindow(), message, "Confirm  " + title, optionType, 3);
    }

    protected void showProgressMessage(String message, BoundedRangeModel rangeModel) {
        StatusBar l_statusBar = this.getMainWindow().getStatusBar();
        l_statusBar.setMessage(message);
    }

    protected void hideProgressMessage() {
        StatusBar l_statusBar = this.getMainWindow().getStatusBar();
        l_statusBar.setMessage(null);
    }

    private Icon getSmallIcon(String iconId) {
        return AbstractApplicationIconFactory.getMenuIcon(iconId);
    }

    protected static String getString(String str) {
        return StringTable.get(str);
    }

    protected static void browseURL(URI uri) {
        Desktop l_desktop = null;
        if (Desktop.isDesktopSupported()) {
            l_desktop = Desktop.getDesktop();
        }
        if (l_desktop != null && l_desktop.isSupported(Desktop.Action.BROWSE)) {
            try {
                l_desktop.browse(uri);
            }
            catch (IOException ex) {
                Logger.getLogger(AbstractApplicationAction.class.getName()).log(Level.SEVERE, null, ex);
                JOptionPane.showMessageDialog(application.getMainWindow(), AbstractApplicationAction.getString(MSG_DESKTOP_FAILED), application.getName(), 0);
            }
        } else {
            JOptionPane.showInputDialog(application.getMainWindow(), AbstractApplicationAction.getString(MSG_DESKTOP_NOT_SUPPORTED), uri.toString());
        }
    }

    protected ImageHelper.ImageFileDescriptor getImageSaveAsFile(File file, String title) {
        JFileChooser l_fc = new JFileChooser();
        File l_file = null;
        l_file = file;
        FileFilter[] l_filters = ImageHelper.getImageFileFilterList();
        FileFilter l_filter = l_filters[0];
        for (FileFilter f : l_filters) {
            l_fc.addChoosableFileFilter(f);
            if (l_file == null || !f.accept(l_file)) continue;
            l_filter = f;
        }
        l_fc.setDialogTitle(title != null ? title : AbstractApplicationAction.getString(STR_WRITE_IMAGE_TITLE));
        l_fc.setSelectedFile(l_file);
        l_fc.setFileFilter(l_filter);
        if (l_fc.showSaveDialog(this.getMainWindow()) != 0) {
            return null;
        }
        l_file = l_fc.getSelectedFile();
        String l_filename = l_file.getName();
        l_filter = l_fc.getFileFilter();
        String l_suffix = ((FileNameExtensionFilter)l_filter).getExtensions()[0];
        if (!l_filename.toLowerCase().endsWith(l_suffix)) {
            l_filename = l_filename + "." + l_suffix;
        }
        if ((l_file = new File(l_file.getParent(), l_filename)).exists() && !this.showConfirmDialog(MessageFormat.format(AbstractApplicationAction.getString(MSG_FILE_OVERWRITE_EXISTING), l_filename), application.getTitle())) {
            return null;
        }
        if (l_file.exists() && !l_file.canWrite()) {
            this.showErrorDialog(MSG_FILE_CANNOT_WRITE, l_filename);
            return null;
        }
        return new ImageHelper.ImageFileDescriptor(l_file, l_suffix);
    }

    public FileFilter createCompositeFileFilter(FileFilter[] filters, String description) {
        return new CompositeFileFilter(filters, description);
    }

    protected void performLengthyTask(Runnable task, String message) {
        LengthyTaskSwingWorker l_worker = new LengthyTaskSwingWorker(task);
        this.showProgressMessage(message, null);
        l_worker.execute();
    }

    static {
        clipboard = new ActionClipboard();
    }

    private class LengthyTaskSwingWorker
    extends SwingWorker<Object, Object> {
        private final Runnable task;
        private String errMessage;

        public LengthyTaskSwingWorker(Runnable task) {
            this.task = task;
            this.errMessage = null;
        }

        @Override
        protected BufferedImage doInBackground() throws Exception {
            try {
                this.task.run();
            }
            catch (Exception ex) {
                Logger.getLogger(FileLoadImageAction.class.getName()).log(Level.SEVERE, null, ex);
                this.errMessage = ex.getMessage();
            }
            return null;
        }

        @Override
        protected void done() {
            AbstractApplicationAction.this.hideProgressMessage();
            if (this.errMessage != null) {
                AbstractApplicationAction.this.showErrorDialog(this.errMessage, application.getTitle());
                return;
            }
        }
    }

    protected static class CompositeFileFilter
    extends FileFilter {
        final FileFilter[] filters;
        final String description;

        public CompositeFileFilter(FileFilter[] filters, String description) {
            this.filters = filters;
            this.description = description;
        }

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            for (FileFilter t : this.filters) {
                if (!t.accept(f)) continue;
                return true;
            }
            return false;
        }

        @Override
        public String getDescription() {
            return this.description;
        }
    }
}

