// CB3ROB BBS Ident/Auth Daemon 1.2 (Ident/Auth protocol RFC 1413)
// Gives loginname or uid (if getpwnam lookup fails) as a reply
// Not user-spoofable ident for user-tracking purposes
// Originally based upon pidentd, removed spoofing and rewritten.
// Copyright (C) 1998-2007 CB3ROB BBS, Republic CyberBunker
// Released into the public domain 2007.
// Run this from an Inetd daemon.

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <pwd.h>
#include <netdb.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#define NOBODY_USER "nobody"
#define PROC_LOCAL "/proc/net/tcp"
#define ETC_DIR "/etc"

#define IDENT_TIMEOUT 60
#define IDENT_PORT 113

int hex_char(char c)
{
	if (c >= '0' && c <= '9') return (c-'0');
	else if (c >= 'A' && c <= 'F') return (c-'A'+0xA);
	else return 0;
}

int hex_to_int(char *str, int cnt)
{
	int i;
	int n=0;
	for (i=0; i<cnt; i++) n = (n<<4) | hex_char(str[i]);
	return n;
}


int get_uid(int lport, unsigned long raddr, int rport)
{
	FILE *tcp;
	char buf[256], *p;
	int i, l, r;
	unsigned long ip;
	uid_t uid;
	
	tcp = fopen(PROC_LOCAL, "r");
	if (!tcp) return -1;   /* should we log/report error somehow? */
	fgets(buf, sizeof buf, tcp);  /* useless header line */
	while (!feof(tcp))
	{
		fgets(buf, sizeof buf, tcp);
		p = strchr(buf, ':');
		if (!p) continue;
		p = strchr(p+1, ':');
		if (!p) continue;
		for (l = i = 0; i < 4; i++) l = (l<<4) | hex_char(*(++p));
		if (l != lport) continue;
		p++;
		ip = 0;
		for (i = 0; i < 8; i++) ip = (ip<<4) | hex_char(*(++p));
		ip = ntohl(ip);
		if (ip != raddr) continue;
		p = strchr(p, ':');
		if (!p) continue;
		for (r = i = 0; i < 4; i++) r = (r<<4) | hex_char(*(++p));
		if (r != rport) continue;
		p = strchr(p+1, ':');
		if (!p) continue;
		p = strchr(p+1, ':');
		if (!p) continue;
		p = strchr(p+1, ' ');
		if (!p) continue;
		p = strchr(p+1, ' ');
		while (*p == ' ') p++;
		uid = atoi(p);
		fclose(tcp);
		return uid;
	}
	fclose(tcp);
	return -1;   /* not found */
}



int do_ident(int in, int out)
{
	struct passwd *user;
	char req[512], reply[512], *p;
	int pos, cnt;
	fd_set rfds;
	struct timeval tv;
	struct sockaddr_in sin;
	int sinlen = sizeof sin;
	int ip;
	int l, r;
	int uid;

	if (getpeername(in, (struct sockaddr *)&sin, &sinlen) == 0)
		ip = ntohl(sin.sin_addr.s_addr);
	else
		ip = 0x7F000001;
	
	pos = 0;
	do
	{
		FD_ZERO(&rfds);
		FD_SET(in, &rfds);
		tv.tv_sec = IDENT_TIMEOUT;
		tv.tv_usec = 0;
		if (select (in+1, &rfds, NULL, NULL, &tv) <= 0) return -1;
		cnt = read(in, req+pos, sizeof req - pos - 1);
		if (cnt <= 0) return -1;
		pos += cnt;
		req[pos] = 0;
		if (sizeof req - pos - 1 == 0) return -1;
	} while (!strpbrk(req, "\r\n"));
	p = req;
	while (*p == ' ') p++;
	l = atoi(p);
	p = strchr(p, ',');
	if (!p) return -1;   /* report error here? */
	p++;
	while (*p == ' ') p++;
	r = atoi(p);

	if (l < 1 || l > 65535 || r < 1 || r > 65535)
	{
		sprintf(reply, "%d , %d : ERROR : INVALID-PORT\r\n", l, r);
		write(out, reply, strlen(reply));
		return 0;
	}
	
	uid = get_uid(l, ip, r);
	if (uid == -1)
	{
		sprintf(reply, "%d , %d : ERROR : NO-USER\r\n", l, r);
		write(out, reply, strlen(reply));
		return 0;
	}
	else
	{
		if (user = getpwuid(uid))
		{
			sprintf(reply, "%d , %d : USERID : UNIX : %.8s\r\n", l, r, user->pw_name);
			write(out,reply,strlen(reply));
			return 0;
		}
		else
		{
			sprintf(reply, "%d , %d : USERID : UNIX : %d\r\n", l, r, uid);
			write(out,reply,strlen(reply));
			return 0;
		}

	}
	
}


int spoof_socket(int cli)
{
	int s;
	struct sockaddr_in sin;
	int sinlen = sizeof sin;
	if (getpeername(cli, (struct sockaddr *)&sin, &sinlen) != 0)
		return -1;
	s = socket(AF_INET, SOCK_STREAM, 0);
	sin.sin_family = AF_INET;
	sin.sin_port = 0;
	if (bind(s, (struct sockaddr *)&sin, sizeof sin) != 0)
	{
		close(s);
		return -1;
	}
	return s;
}

void drop_root()
{
	/* do NOT run an identd as root! */
	if (getuid() == 0 || geteuid() == 0)
	{
		struct passwd *nobody;
		nobody = getpwnam(NOBODY_USER);
		if (!nobody) exit(1);
		setregid(nobody->pw_gid, nobody->pw_gid);
		setgroups(1, &nobody->pw_gid);
		setreuid(nobody->pw_uid, nobody->pw_uid);
	}
}

int main(int argc, char *argv[])
{
	int status;

        spoof_socket(0);
	drop_root();

	status = do_ident(0, 1);
	close(0);
	close(1);
	close(2);
	return status;
}
