/* antivir_start. Start AntiVir products as root.
   Copyright (c) 2004-2006 H+BEDV Datentechnik GmbH

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

/*
   This program will start various AntiVir products.
   This program is meant to be setuid root:

   # chown root antivir_start
   # chmod u+s antivir_start
*/

#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <sys/types.h>
#include <sys/wait.h>

void print_usage()
{
	printf("usage: antivir_start <product> [options]\n");
	printf("\n");
	printf("Products:\n");
	printf("  mailgate\n");
	printf("  webgate\n");
	printf("  guard_workstation\n");
	printf("  guard_server\n");
	printf("  update\n");
	printf("\n");
	printf("MailGate Options:\n");
	printf("  --mailgate-conf=<file>\n");
	printf("\n");
	printf("WebGate Options:\n");
	printf("  --webgate-conf=<file>\n");
	printf("\n");
	printf("uid=%d euid=%d gid=%d egid=%d\n", getuid(), geteuid(), getgid(), getegid());
	printf("\n");
}

void exec_fork(char *const command[])
{
	pid_t pid;
	int status;

	pid = fork();
	if (pid == 0)
	{
		setsid();
		if (fork() == 0)
		{
			execvp(command[0], command);
		}
	}
	else if (pid > 0)
	{
		waitpid(pid, &status, 0);
	}
}

int main(int argc, char *argv[])
{
	char *const guard_workstation[] = { "/usr/lib/AntiVir/avguard", "start", NULL };
	char *const guard_server[] = { "/usr/lib/AntiVir/avguard", "start", NULL };
	char *const update[] = { "/usr/lib/AntiVir/antivir", "--update", NULL };

	char * webgate[] = { "/usr/lib/AntiVir/avwebgate.bin", NULL, NULL, NULL };
	char * mailgate1[] = { "/usr/sbin/avgated", NULL, NULL, NULL };
	char * mailgate2[] = { "/usr/sbin/avgatefwd", NULL, NULL, NULL };
	char * mailgate3[] = { "/usr/lib/AntiVir/avmailgate.bin", NULL, NULL, NULL };

	setuid(geteuid());

	if (argc < 2)
	{
		print_usage();
		return -1;
	}

	if (strcmp(argv[1], "webgate") == 0)
	{
		if (argc == 3)
		{

#define WEBGATECONFARG "--webgate-conf="
#define WEBGATECONFARG_LENGTH strlen("--webgate-conf=")

			if (strncmp(argv[2], WEBGATECONFARG, WEBGATECONFARG_LENGTH) == 0)
			{
				webgate[1] = "-C";
				webgate[2] = argv[2] + WEBGATECONFARG_LENGTH;
			}

#undef WEBGATECONFARG
#undef WEBGATECONFARG_LENGTH

		}

		return execvp(webgate[0], webgate);
	}
	else if (strcmp(argv[1], "update") == 0)
	{
		return execvp(update[0], update);
	}
	else if (strcmp(argv[1], "guard_workstation") == 0)
	{
		return execvp(guard_workstation[0], guard_workstation);
	}
	else if (strcmp(argv[1], "guard_server") == 0)
	{
		return execvp(guard_server[0], guard_server);
	}
	else if (strcmp(argv[1], "mailgate") == 0)
	{
		if (argc == 3)
		{

#define MAILGATECONFARG "--mailgate-conf="
#define MAILGATECONFARG_LENGTH strlen("--mailgate-conf=")

			if (strncmp(argv[2], MAILGATECONFARG, MAILGATECONFARG_LENGTH) == 0)
			{
				mailgate1[1] = "-C";
				mailgate1[2] = argv[2] + MAILGATECONFARG_LENGTH;
				mailgate2[1] = "-C";
				mailgate2[2] = argv[2] + MAILGATECONFARG_LENGTH;
				mailgate3[1] = "-C";
				mailgate3[2] = argv[2] + MAILGATECONFARG_LENGTH;
			}

#undef MAILGATECONFARG
#undef MAILGATECONFARG_LENGTH

		}

		if (access(mailgate3[0], F_OK) == 0)
		{
			return execvp(mailgate3[0], mailgate3);
		}

		exec_fork(mailgate1);

		return execvp(mailgate2[0], mailgate2);
	}
	else
	{
		print_usage();
	}

	return -1;
}
