#ifndef __VSCAN_ANTIVIR_H_
#define __VSCAN_ANTIVIR_H_

#include "vscan-global.h"

/* Configuration Section :-) */

/* program name for scanner process */
#define VSCAN_ANTIVIR_PROGRAM_NAME	"/usr/lib/AntiVir/antivir"

/* enable scan in archive files */
#define VSCAN_AVARCH_ENABLED		0
/* maximum compression ratio of files in archive */
#define VSCAN_AVARCH_MAXRATIO		150
/* maximum archived file size (in bytes) */
#define VSCAN_AVARCH_MAXFILESIZE	(1024 * 1048576)
/* maximum recursion level */
#define VSCAN_AVARCH_MAXRECLEVEL	5

/* non virus types of alerts (all off by default) */
#define VSCAN_AVDETECT_DIALER		0
#define VSCAN_AVDETECT_GAME		0
#define VSCAN_AVDETECT_JOKE		0
#define VSCAN_AVDETECT_PMS		0
#define VSCAN_AVDETECT_SPY		0
#define VSCAN_AVDETECT_ALLTYPES		0

/* default location of samba-style configuration file (needs Samba >= 2.2.4
 or Samba 3.0 */

#define PARAMCONF "/etc/samba/vscan-antivir.conf"


/* False = log only concerning file, True = log every file access */

#ifndef VSCAN_VERBOSE_FILE_LOGGING
# define VSCAN_VERBOSE_FILE_LOGGING False
#endif

/* if a file is bigger than VSCAN_MAX_SIZE it won't be scanned. Has to be
   specified in bytes! If it set to 0, the file size check is disabled */

#ifndef VSCAN_MAX_SIZE
# define VSCAN_MAX_SIZE 0
#endif

/* True = scan files on open */

#ifndef VSCAN_SCAN_ON_OPEN
# define VSCAN_SCAN_ON_OPEN True
#endif

/* True = scan files on close */

#ifndef VSCAN_SCAN_ON_CLOSE
# define VSCAN_SCAN_ON_CLOSE True
#endif

/* True = deny access in case of scanning failure */

#ifndef VSCAN_DENY_ACCESS_ON_ERROR
# define VSCAN_DENY_ACCESS_ON_ERROR True
#endif

/* True = deny access in case of minor scanning failure */

#ifndef VSCAN_DENY_ACCESS_ON_MINOR_ERROR
# define VSCAN_DENY_ACCESS_ON_MINOR_ERROR True
#endif

/* True = send a warning message via window messenger service for alerts found */

#ifndef VSCAN_SEND_WARNING_MESSAGE
# define VSCAN_SEND_WARNING_MESSAGE True
#endif

/* default concerning file action */
#define VSCAN_INFECTED_FILE_ACTION INFECTED_QUARANTINE

/* default quarantine settings; hopefully the user changes this */
#define VSCAN_QUARANTINE_DIRECTORY	"/tmp"
#define VSCAN_QUARANTINE_PREFIX		"vir-"

/* set default value for maximum lrufile entries */
#define VSCAN_MAX_LRUFILES 100

/* time after an entry is considered as expired */
#define VSCAN_LRUFILES_INVALIDATE_TIME 5

/* MIME-types of files to be exluded from scanning; that's an
   semi-colon seperated list */
#define VSCAN_FT_EXCLUDE_LIST ""


/* End Configuration Section */

/* functions by vscan-antivir_core */

/* user connects to a share (might startup scanner daemon) */
int vscan_antivir_connect(void);

/* prepare a scan (might open a socket) */
int vscan_antivir_init(void);

/* scan a file */
int vscan_antivir_scanfile(int sockfd, char *scan_file, char *client_ip);

/* end a scan (might close a socket) */
void vscan_antivir_end(int sockfd);

/* user disconnects from a share (might shutdown scanner daemon) */
void vscan_antivir_disconnect(void);


#endif /* __VSCAN_ANTIVIR_H_ */
