/*
 * Decompiled with CFR 0.152.
 */
package paulscode.sound.utils;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import paulscode.sound.SoundSystemConfig;
import paulscode.sound.SoundSystemLogger;
import paulscode.sound.utils.XMLParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLNode {
    private static SoundSystemLogger logger;
    private static boolean verbose;
    protected String name = "";
    protected String contents = "";
    protected HashMap<String, String> parameters = null;
    protected XMLNode next = null;

    public XMLNode(String string) {
        int n = string.indexOf("<");
        int n2 = string.indexOf(">");
        if (n == -1 || n2 == -1) {
            return;
        }
        if (n2 <= n) {
            XMLNode.errorMessage("Invalid XML syntax: '>' before '<'");
            return;
        }
        this.parameters = new HashMap();
        this.contents = string.substring(n + 1, n2);
        this.processTagContents(this.contents);
        if (verbose) {
            this.displayParameters();
        }
        if (n2 + 1 >= string.length()) {
            return;
        }
        String string2 = string.substring(n2 + 1);
        n = string2.indexOf("<");
        if (n == -1) {
            return;
        }
        this.next = new XMLNode(string2.substring(n));
    }

    public String name() {
        if (this.name == null) {
            return "";
        }
        return this.name;
    }

    public String contents() {
        if (this.contents == null) {
            return "";
        }
        return this.contents;
    }

    public boolean hasNext() {
        return this.next != null;
    }

    public XMLNode next() {
        return this.next;
    }

    public String get(String string) {
        if (this.parameters == null) {
            return "";
        }
        return this.parameters.get(string.toUpperCase());
    }

    public HashMap<String, String> parameters() {
        return this.parameters;
    }

    public void displayParameters() {
        System.out.println("Parameters for " + this.name + ":");
        Set<String> set = this.parameters.keySet();
        Iterator<String> iterator = set.iterator();
        if (!iterator.hasNext()) {
            System.out.println("    (none)");
        }
        while (iterator.hasNext()) {
            String string = iterator.next();
            String string2 = this.parameters.get(string);
            System.out.println("    " + string + " = " + string2);
        }
    }

    protected void processTagContents(String string) {
        String[] stringArray = XMLParser.seperateWords(string);
        if (stringArray.length > 0) {
            String string2;
            this.name = stringArray[0];
            if (this.name.length() >= 3 && this.name.substring(0, 3).equals("!--")) {
                return;
            }
            int n = 1;
            while (n < stringArray.length && !(string2 = stringArray[n]).equals("/")) {
                String[] stringArray2;
                if (string2.contains("=")) {
                    stringArray2 = string2.split("=");
                    if (stringArray2 == null || stringArray2.length == 0) {
                        XMLNode.errorMessage("Invalid XML syntax: paramater null");
                        return;
                    }
                    if (stringArray2.length == 1) {
                        if (n + 1 >= stringArray.length) {
                            XMLNode.warningMessage("Value not specified for parameter '" + stringArray2[0] + "'");
                            this.parameters.put(stringArray2[0].toUpperCase(), "");
                            ++n;
                            continue;
                        }
                        this.parameters.put(stringArray2[0].toUpperCase(), stringArray[n + 1]);
                        n += 2;
                        continue;
                    }
                    this.parameters.put(stringArray2[0].toUpperCase(), stringArray2[1]);
                    ++n;
                    continue;
                }
                if (n + 1 >= stringArray.length) {
                    XMLNode.warningMessage("Value not specified for parameter '" + stringArray[n] + "'");
                    this.parameters.put(stringArray[n].toUpperCase(), "");
                    ++n;
                    continue;
                }
                if (stringArray[n + 1].equals("=")) {
                    if (n + 2 >= stringArray.length) {
                        XMLNode.warningMessage("Value not specified for parameter '" + stringArray[n] + "'");
                        this.parameters.put(stringArray[n].toUpperCase(), "");
                        n += 2;
                        continue;
                    }
                    this.parameters.put(stringArray[n].toUpperCase(), stringArray[n + 2]);
                    n += 3;
                    continue;
                }
                if (stringArray[n + 1].contains("=")) {
                    stringArray2 = stringArray[n + 1].split("=");
                    if (stringArray2 == null || stringArray2.length < 1) {
                        XMLNode.warningMessage("Value not specified for parameter '" + stringArray[n] + "'");
                        this.parameters.put(stringArray[n].toUpperCase(), "");
                        n += 2;
                        continue;
                    }
                    this.parameters.put(stringArray[n].toUpperCase(), stringArray2[1]);
                    n += 2;
                    continue;
                }
                XMLNode.warningMessage("Value not specified for parameter '" + stringArray[n] + "'");
                this.parameters.put(stringArray[n].toUpperCase(), "");
                ++n;
            }
        }
    }

    public static void setVerbose(boolean bl) {
        verbose = bl;
    }

    protected static void errorMessage(String string) {
        if (logger == null) {
            logger = SoundSystemConfig.getLogger();
        }
        if (logger == null) {
            logger = new SoundSystemLogger();
            SoundSystemConfig.setLogger(logger);
        }
        logger.errorMessage("XMLNode", string, 0);
    }

    protected static void warningMessage(String string) {
        if (logger == null) {
            logger = SoundSystemConfig.getLogger();
        }
        if (logger == null) {
            logger = new SoundSystemLogger();
            SoundSystemConfig.setLogger(logger);
        }
        logger.importantMessage("Warning in class 'XMLNode': " + string, 0);
    }

    static {
        verbose = false;
    }
}

