/*
 * Decompiled with CFR 0.152.
 */
package paulscode.sound.utils;

import java.net.URL;
import paulscode.sound.CommandObject;
import paulscode.sound.FilenameURL;
import paulscode.sound.SoundSystem;
import paulscode.sound.SoundSystemConfig;
import paulscode.sound.SoundSystemException;
import paulscode.sound.SoundSystemLogger;
import paulscode.sound.utils.XMLNode;
import paulscode.sound.utils.XMLParser;

public class SoundSystemLoader {
    private static SoundSystemLogger logger;
    private static boolean verbose;

    public static SoundSystem loadXML(URL uRL, SoundSystem soundSystem) {
        if (uRL == null) {
            SoundSystemLoader.errorMessage("Parameter 'xmlFile' null in method 'loadXML'");
            return null;
        }
        XMLNode xMLNode = XMLParser.parseXML(uRL);
        if (xMLNode == null) {
            SoundSystemLoader.warningMessage("No commands found in XML file");
            return null;
        }
        Class<?> clazz = null;
        while (xMLNode != null) {
            String string = xMLNode.name().toUpperCase();
            if (string != null && !string.substring(0, 1).equals("/")) {
                String string2;
                if (string.equals("ADDLIBRARY")) {
                    if (verbose) {
                        SoundSystemLoader.message("SoundSystemLoader.loadXML:  addLibrary", 0);
                        SoundSystemLoader.message("Class name:  " + xMLNode.get("CLASSNAME"), 1);
                    }
                    try {
                        clazz = Class.forName(xMLNode.get("CLASSNAME"));
                        if (verbose) {
                            SoundSystemLoader.message("Command:  SoundSystemConfig.addLibrary( " + xMLNode.get("CLASSNAME") + ".class );", 1);
                        }
                        SoundSystemConfig.addLibrary(clazz);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        SoundSystemLoader.errorMessage("Unable to add library plug-in in method 'loadXML':  Class name '" + xMLNode.get("CLASSNAME") + "' not found.");
                    }
                    catch (SoundSystemException soundSystemException) {
                        SoundSystemLoader.printStackTrace(soundSystemException);
                    }
                } else if (string.equals("SETCODEC")) {
                    if (verbose) {
                        SoundSystemLoader.message("SoundSystemLoader.loadXML:  setCodec", 0);
                        SoundSystemLoader.message("Extension: " + xMLNode.get("EXTENSION"), 1);
                        SoundSystemLoader.message("Class name: " + xMLNode.get("CLASSNAME"), 1);
                    }
                    try {
                        clazz = Class.forName(xMLNode.get("CLASSNAME"));
                        if (verbose) {
                            SoundSystemLoader.message("Command:  SoundSystemConfig.setCodec( \"" + xMLNode.get("EXTENSION") + "\", " + xMLNode.get("CLASSNAME") + ".class );", 1);
                        }
                        SoundSystemConfig.setCodec(xMLNode.get("EXTENSION"), clazz);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        SoundSystemLoader.errorMessage("Unable to set codec plug-in for extension '" + xMLNode.get("EXTENSION") + "' in method 'loadXML':  Class name '" + xMLNode.get("CLASSNAME") + "' not found.");
                    }
                    catch (SoundSystemException soundSystemException) {
                        SoundSystemLoader.printStackTrace(soundSystemException);
                    }
                } else if (string.equals("CREATE")) {
                    if (verbose) {
                        SoundSystemLoader.message("SoundSystemLoader.loadXML:  create", 0);
                    }
                    if (soundSystem != null) {
                        soundSystem.cleanup();
                    }
                    soundSystem = null;
                    string2 = xMLNode.get("CLASSNAME");
                    if (string2 != null && !string2.equals("")) {
                        try {
                            clazz = Class.forName(string2);
                            if (verbose) {
                                SoundSystemLoader.message("Command:  s = (SoundSystem) new " + string2 + "();", 1);
                                soundSystem = (SoundSystem)clazz.newInstance();
                            }
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            SoundSystemLoader.printStackTrace(classNotFoundException);
                        }
                        catch (InstantiationException instantiationException) {
                            SoundSystemLoader.printStackTrace(instantiationException);
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            SoundSystemLoader.printStackTrace(illegalAccessException);
                        }
                        if (verbose) {
                            SoundSystemLoader.message("Unable to instantiate the Sound System in method 'loadXML'  Returning null.", 1);
                            if (soundSystem != null) {
                                soundSystem.cleanup();
                            }
                            soundSystem = null;
                            return null;
                        }
                    } else {
                        if (verbose) {
                            SoundSystemLoader.message("Command:  s = new SoundSystem();", 1);
                        }
                        soundSystem = new SoundSystem();
                    }
                } else if (string.equals("LOADSOUND")) {
                    if (verbose) {
                        SoundSystemLoader.message("SoundSystemLoader.loadXML:  loadSound", 0);
                        SoundSystemLoader.message("Filename: " + xMLNode.get("FILENAME"), 1);
                    }
                    if (soundSystem == null) {
                        SoundSystemLoader.errorMessage("Encountered 'loadSound' command before SoundSystem was instantiated in method 'loadXML'.  returning null.");
                        return null;
                    }
                    if (verbose) {
                        SoundSystemLoader.message("Command:  s.loadSound( \"" + xMLNode.get("FILENAME") + "\" );", 1);
                    }
                    soundSystem.loadSound(xMLNode.get("FILENAME"));
                } else if (string.equals("NEWSOURCE")) {
                    if (verbose) {
                        SoundSystemLoader.message("SoundSystemLoader.loadXML:  newSource", 0);
                    }
                    if (soundSystem == null) {
                        SoundSystemLoader.errorMessage("Encountered 'newSource' command before SoundSystem was instantiated in method 'loadXML'.  returning null.");
                        return null;
                    }
                    boolean bl = false;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    String string3 = "";
                    String string4 = "";
                    float f = 0.0f;
                    float f2 = 0.0f;
                    float f3 = 0.0f;
                    int n = SoundSystemConfig.getDefaultAttenuation();
                    float f4 = 0.0f;
                    string2 = xMLNode.get("PRIORITY");
                    if (string2 != null && !string2.equals("")) {
                        if (verbose) {
                            SoundSystemLoader.message("PRIORITY: " + string2, 1);
                        }
                        if (string2.toUpperCase().equals("TRUE")) {
                            bl = true;
                        }
                    }
                    if ((string2 = xMLNode.get("TOSTREAM")) != null && !string2.equals("")) {
                        if (verbose) {
                            SoundSystemLoader.message("TOSTREAM: " + string2, 1);
                        }
                        if (string2.toUpperCase().equals("TRUE")) {
                            bl2 = true;
                        }
                    }
                    if ((string2 = xMLNode.get("TOLOOP")) != null && !string2.equals("")) {
                        if (verbose) {
                            SoundSystemLoader.message("TOLOOP: " + string2, 1);
                        }
                        if (string2.toUpperCase().equals("TRUE")) {
                            bl3 = true;
                        }
                    }
                    if ((string2 = xMLNode.get("SOURCENAME")) != null && !string2.equals("")) {
                        if (verbose) {
                            SoundSystemLoader.message("SOURCENAME: " + string2, 1);
                        }
                        string3 = string2;
                    }
                    if ((string2 = xMLNode.get("FILENAME")) != null && !string2.equals("")) {
                        if (verbose) {
                            SoundSystemLoader.message("FILENAME: " + string2, 1);
                        }
                        string4 = string2;
                    }
                    if ((string2 = xMLNode.get("X")) != null && !string2.equals("")) {
                        if (verbose) {
                            SoundSystemLoader.message("X: " + string2, 1);
                        }
                        try {
                            f = Float.parseFloat(string2);
                        }
                        catch (NumberFormatException numberFormatException) {
                            SoundSystemLoader.errorMessage("Error parsing float 'X' from String '" + string2 + "' in " + "method 'loadXML'.  Using x=0");
                            f = 0.0f;
                        }
                    }
                    if ((string2 = xMLNode.get("Y")) != null && !string2.equals("")) {
                        if (verbose) {
                            SoundSystemLoader.message("Y: " + string2, 1);
                        }
                        try {
                            f2 = Float.parseFloat(string2);
                        }
                        catch (NumberFormatException numberFormatException) {
                            SoundSystemLoader.errorMessage("Error parsing float 'Y' from String '" + string2 + "' in " + "method 'loadXML'.  Using y=0");
                            f2 = 0.0f;
                        }
                    }
                    if ((string2 = xMLNode.get("Z")) != null && !string2.equals("")) {
                        if (verbose) {
                            SoundSystemLoader.message("Z: " + string2, 1);
                        }
                        try {
                            f = Float.parseFloat(string2);
                        }
                        catch (NumberFormatException numberFormatException) {
                            SoundSystemLoader.errorMessage("Error parsing float 'Z' from String '" + string2 + "' in " + "method 'loadXML'.  Using z=0");
                            f3 = 0.0f;
                        }
                    }
                    if ((string2 = xMLNode.get("ATTMODEL")) != null && !string2.equals("")) {
                        if (verbose) {
                            SoundSystemLoader.message("ATTMODEL: " + string2, 1);
                        }
                        if (string2.toUpperCase().contains("NONE")) {
                            n = 0;
                        } else if (string2.toUpperCase().contains("LINEAR")) {
                            n = 2;
                        } else if (string2.toUpperCase().contains("ROLLOFF")) {
                            n = 1;
                        }
                    }
                    if ((string2 = xMLNode.get("DISTORROLL")) != null && !string2.equals("")) {
                        if (verbose) {
                            SoundSystemLoader.message("DISTORROLL: " + string2, 1);
                        }
                        try {
                            f4 = Float.parseFloat(string2);
                        }
                        catch (NumberFormatException numberFormatException) {
                            SoundSystemLoader.errorMessage("Error parsing float 'DISTORROLL' from String '" + string2 + "' in method " + "'loadXML'.  Using default value.");
                            f4 = 0.0f;
                            if (n == 2) {
                                f4 = SoundSystemConfig.getDefaultFadeDistance();
                            } else if (n == 1) {
                                f4 = SoundSystemConfig.getDefaultAttenuation();
                            }
                        }
                    } else if (n == 2) {
                        f4 = SoundSystemConfig.getDefaultFadeDistance();
                    } else if (n == 1) {
                        f4 = SoundSystemConfig.getDefaultAttenuation();
                    }
                    if (string3.equals("")) {
                        SoundSystemLoader.errorMessage("Parameter 'SOURCENAME' not specified for 'NEWSOURCE' tag in method 'loadXML.  Unable to create new source.");
                    } else if (string4.equals("")) {
                        SoundSystemLoader.errorMessage("Parameter 'FILENAME' not specified for 'NEWSOURCE' tag in method 'loadXML.  Unable to create new source.");
                    } else {
                        if (verbose) {
                            SoundSystemLoader.message("Command:  s.CommandQueue( new paulscode.sound.CommandObject( paulscode.sound.CommandObject.NEW_SOURCE, " + bl + ", " + bl2 + ", " + bl3 + ", \"" + string3 + "\", " + "new paulscode.sound.FilenameURL( \"" + string4 + "\" ), " + f + ", " + f2 + ", " + f3 + ", " + n + ", " + f4 + " ) );", 1);
                        }
                        soundSystem.CommandQueue(new CommandObject(10, bl, bl2, bl3, string3, new FilenameURL(string4), f, f2, f3, n, f4));
                        if (verbose) {
                            SoundSystemLoader.message("Command:  s.interruptCommandThread();", 1);
                        }
                        soundSystem.interruptCommandThread();
                    }
                } else if (string.length() >= 3 && string.substring(0, 3).equals("!--")) {
                    if (verbose) {
                        SoundSystemLoader.message("SoundSystemLoader.loadXML:  comment", 0);
                        if (xMLNode.contents().length() > 6) {
                            SoundSystemLoader.message(xMLNode.contents().substring(3, xMLNode.contents().length() - 2), 1);
                        }
                    }
                } else if (verbose) {
                    SoundSystemLoader.message("SoundSystemLoader.loadXML:  " + string, 0);
                    SoundSystemLoader.message("Unrecognized tag.", 1);
                } else {
                    SoundSystemLoader.warningMessage("Command '" + string + "' not " + "recognized in method 'loadXML'");
                }
            }
            xMLNode = xMLNode.next();
        }
        return soundSystem;
    }

    public static void setVerbose(boolean bl) {
        verbose = bl;
    }

    protected static void message(String string, int n) {
        if (logger == null) {
            logger = SoundSystemConfig.getLogger();
        }
        if (logger == null) {
            logger = new SoundSystemLogger();
            SoundSystemConfig.setLogger(logger);
        }
        logger.message(string, n);
    }

    protected static void errorMessage(String string) {
        if (logger == null) {
            logger = SoundSystemConfig.getLogger();
        }
        if (logger == null) {
            logger = new SoundSystemLogger();
            SoundSystemConfig.setLogger(logger);
        }
        logger.errorMessage("SoundSystemLoader", string, 0);
    }

    protected static void warningMessage(String string) {
        if (logger == null) {
            logger = SoundSystemConfig.getLogger();
        }
        if (logger == null) {
            logger = new SoundSystemLogger();
            SoundSystemConfig.setLogger(logger);
        }
        logger.importantMessage("Warning in class 'SoundSystemLoader': " + string, 0);
    }

    protected static void printStackTrace(Exception exception) {
        if (logger == null) {
            logger = SoundSystemConfig.getLogger();
        }
        if (logger == null) {
            logger = new SoundSystemLogger();
            SoundSystemConfig.setLogger(logger);
        }
        logger.printStackTrace(exception, 1);
    }

    static {
        verbose = false;
    }
}

