/*
 * Decompiled with CFR 0.152.
 */
package paulscode.sound.codecs;

import de.jarnbjo.ogg.CachedUrlStream;
import de.jarnbjo.ogg.EndOfOggStreamException;
import de.jarnbjo.ogg.LogicalOggStream;
import de.jarnbjo.vorbis.IdentificationHeader;
import de.jarnbjo.vorbis.VorbisStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import paulscode.sound.ICodec;
import paulscode.sound.SoundBuffer;
import paulscode.sound.SoundSystemConfig;
import paulscode.sound.SoundSystemLogger;

public class CodecJOgg
implements ICodec {
    private static final boolean GET = false;
    private static final boolean SET = true;
    private static final boolean XXX = false;
    private boolean endOfStream = false;
    private boolean initialized = false;
    private boolean reverseBytes = false;
    private CachedUrlStream cachedUrlStream = null;
    private LogicalOggStream myLogicalOggStream = null;
    private VorbisStream myVorbisStream = null;
    private OggInputStream myOggInputStream = null;
    private IdentificationHeader myIdentificationHeader = null;
    private AudioFormat myAudioFormat = null;
    private AudioInputStream myAudioInputStream = null;
    private SoundSystemLogger logger = SoundSystemConfig.getLogger();

    public void reverseByteOrder(boolean bl) {
        this.reverseBytes = bl;
    }

    public boolean initialize(URL uRL) {
        this.initialized(true, false);
        this.cleanup();
        if (uRL == null) {
            this.errorMessage("url null in method 'initialize'");
            this.cleanup();
            return false;
        }
        try {
            this.cachedUrlStream = new CachedUrlStream(uRL);
            this.myLogicalOggStream = (LogicalOggStream)this.cachedUrlStream.getLogicalStreams().iterator().next();
            this.myVorbisStream = new VorbisStream(this.myLogicalOggStream);
            this.myOggInputStream = new OggInputStream(this.myVorbisStream);
            this.myIdentificationHeader = this.myVorbisStream.getIdentificationHeader();
            this.myAudioFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, this.myIdentificationHeader.getSampleRate(), 16, this.myIdentificationHeader.getChannels(), this.myIdentificationHeader.getChannels() * 2, this.myIdentificationHeader.getSampleRate(), true);
            this.myAudioInputStream = new AudioInputStream(this.myOggInputStream, this.myAudioFormat, -1L);
        }
        catch (Exception exception) {
            this.errorMessage("Unable to set up input streams in method 'initialize'");
            this.printStackTrace(exception);
            this.cleanup();
            return false;
        }
        if (this.myAudioInputStream == null) {
            this.errorMessage("Unable to set up audio input stream in method 'initialize'");
            this.cleanup();
            return false;
        }
        this.endOfStream(true, false);
        this.initialized(true, true);
        return true;
    }

    public boolean initialized() {
        return this.initialized(false, false);
    }

    public SoundBuffer read() {
        int n;
        if (this.myAudioInputStream == null) {
            this.endOfStream(true, true);
            return null;
        }
        AudioFormat audioFormat = this.myAudioInputStream.getFormat();
        if (audioFormat == null) {
            this.errorMessage("Audio Format null in method 'read'");
            this.endOfStream(true, true);
            return null;
        }
        int n2 = 0;
        byte[] byArray = new byte[SoundSystemConfig.getStreamingBufferSize()];
        try {
            for (n = 0; !this.endOfStream(false, false) && n < byArray.length; n += n2) {
                n2 = this.myAudioInputStream.read(byArray, n, byArray.length - n);
                if (n2 > 0) continue;
                this.endOfStream(true, true);
                break;
            }
        }
        catch (IOException iOException) {
            this.endOfStream(true, true);
            return null;
        }
        if (n <= 0) {
            this.endOfStream(true, true);
            return null;
        }
        if (this.reverseBytes) {
            CodecJOgg.reverseBytes(byArray, 0, n);
        }
        if (n < byArray.length) {
            byArray = CodecJOgg.trimArray(byArray, n);
        }
        byte[] byArray2 = CodecJOgg.convertAudioBytes(byArray, audioFormat.getSampleSizeInBits() == 16);
        SoundBuffer soundBuffer = new SoundBuffer(byArray2, audioFormat);
        return soundBuffer;
    }

    public SoundBuffer readAll() {
        int n;
        int n2;
        if (this.myAudioFormat == null) {
            this.errorMessage("Audio Format null in method 'readAll'");
            return null;
        }
        byte[] byArray = null;
        int n3 = this.myAudioFormat.getChannels() * (int)this.myAudioInputStream.getFrameLength() * this.myAudioFormat.getSampleSizeInBits() / 8;
        if (n3 > 0) {
            byArray = new byte[this.myAudioFormat.getChannels() * (int)this.myAudioInputStream.getFrameLength() * this.myAudioFormat.getSampleSizeInBits() / 8];
            n2 = 0;
            try {
                for (n = 0; (n2 = this.myAudioInputStream.read(byArray, n, byArray.length - n)) != -1 && n < byArray.length; n += n2) {
                }
            }
            catch (IOException iOException) {
                this.errorMessage("Exception thrown while reading from the AudioInputStream (location #1).");
                this.printStackTrace(iOException);
                return null;
            }
        }
        n = 0;
        int n4 = 0;
        byte[] byArray2 = null;
        byArray2 = new byte[SoundSystemConfig.getFileChunkSize()];
        for (n2 = 0; !this.endOfStream(false, false) && n2 < SoundSystemConfig.getMaxFileSize(); n2 += n) {
            n4 = 0;
            try {
                for (n = 0; n < byArray2.length; n += n4) {
                    n4 = this.myAudioInputStream.read(byArray2, n, byArray2.length - n);
                    if (n4 > 0) continue;
                    this.endOfStream(true, true);
                    break;
                }
            }
            catch (IOException iOException) {
                this.errorMessage("Exception thrown while reading from the AudioInputStream (location #2).");
                this.printStackTrace(iOException);
                return null;
            }
            if (this.reverseBytes) {
                CodecJOgg.reverseBytes(byArray2, 0, n);
            }
            byArray = CodecJOgg.appendByteArrays(byArray, byArray2, n);
        }
        byte[] byArray3 = CodecJOgg.convertAudioBytes(byArray, this.myAudioFormat.getSampleSizeInBits() == 16);
        SoundBuffer soundBuffer = new SoundBuffer(byArray3, this.myAudioFormat);
        try {
            this.myAudioInputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return soundBuffer;
    }

    public boolean endOfStream() {
        return this.endOfStream(false, false);
    }

    public void cleanup() {
        if (this.myLogicalOggStream != null) {
            try {
                this.myLogicalOggStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.myVorbisStream != null) {
            try {
                this.myVorbisStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.myOggInputStream != null) {
            try {
                this.myOggInputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.myAudioInputStream != null) {
            try {
                this.myAudioInputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.myLogicalOggStream = null;
        this.myVorbisStream = null;
        this.myOggInputStream = null;
        this.myAudioInputStream = null;
    }

    public AudioFormat getAudioFormat() {
        return this.myAudioFormat;
    }

    private synchronized boolean initialized(boolean bl, boolean bl2) {
        if (bl) {
            this.initialized = bl2;
        }
        return this.initialized;
    }

    private synchronized boolean endOfStream(boolean bl, boolean bl2) {
        if (bl) {
            this.endOfStream = bl2;
        }
        return this.endOfStream;
    }

    private static byte[] trimArray(byte[] byArray, int n) {
        byte[] byArray2 = null;
        if (byArray != null && byArray.length > n) {
            byArray2 = new byte[n];
            System.arraycopy(byArray, 0, byArray2, 0, n);
        }
        return byArray2;
    }

    private static byte[] convertAudioBytes(byte[] byArray, boolean bl) {
        Object object;
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(byArray.length);
        byteBuffer.order(ByteOrder.nativeOrder());
        ByteBuffer byteBuffer2 = ByteBuffer.wrap(byArray);
        byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
        if (bl) {
            object = byteBuffer.asShortBuffer();
            ShortBuffer shortBuffer = byteBuffer2.asShortBuffer();
            while (shortBuffer.hasRemaining()) {
                ((ShortBuffer)object).put(shortBuffer.get());
            }
        } else {
            while (byteBuffer2.hasRemaining()) {
                byteBuffer.put(byteBuffer2.get());
            }
        }
        byteBuffer.rewind();
        if (!byteBuffer.hasArray()) {
            object = new byte[byteBuffer.capacity()];
            byteBuffer.get((byte[])object);
            byteBuffer.clear();
            return object;
        }
        return byteBuffer.array();
    }

    private static byte[] appendByteArrays(byte[] byArray, byte[] byArray2, int n) {
        byte[] byArray3;
        if (byArray == null && byArray2 == null) {
            return null;
        }
        if (byArray == null) {
            byArray3 = new byte[n];
            System.arraycopy(byArray2, 0, byArray3, 0, n);
            byArray2 = null;
        } else if (byArray2 == null) {
            byArray3 = new byte[byArray.length];
            System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
            byArray = null;
        } else {
            byArray3 = new byte[byArray.length + n];
            System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
            System.arraycopy(byArray2, 0, byArray3, byArray.length, n);
            byArray = null;
            byArray2 = null;
        }
        return byArray3;
    }

    public static void reverseBytes(byte[] byArray) {
        CodecJOgg.reverseBytes(byArray, 0, byArray.length);
    }

    public static void reverseBytes(byte[] byArray, int n, int n2) {
        for (int i = n; i < n + n2; i += 2) {
            byte by = byArray[i];
            byArray[i] = byArray[i + 1];
            byArray[i + 1] = by;
        }
    }

    private void errorMessage(String string) {
        this.logger.errorMessage("CodecJOgg", string, 0);
    }

    private void printStackTrace(Exception exception) {
        this.logger.printStackTrace(exception, 1);
    }

    private class OggInputStream
    extends InputStream {
        private VorbisStream myVorbisStream;

        public OggInputStream(VorbisStream vorbisStream) {
            this.myVorbisStream = vorbisStream;
        }

        public int read() throws IOException {
            return 0;
        }

        public int read(byte[] byArray) throws IOException {
            return this.read(byArray, 0, byArray.length);
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            try {
                return this.myVorbisStream.readPcm(byArray, n, n2);
            }
            catch (EndOfOggStreamException endOfOggStreamException) {
                return -1;
            }
        }
    }
}

