/*
 * Decompiled with CFR 0.152.
 */
package org.joone.util;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.joone.engine.Layer;
import org.joone.engine.Monitor;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;
import org.joone.net.NeuralNet;
import org.joone.util.SnapshotPlugin;

public class SnapshotRecorder
extends SnapshotPlugin
implements Serializable {
    private static final long serialVersionUID = -8151866025667526018L;
    private static final ILogger log = LoggerFactory.getLogger(SnapshotRecorder.class);
    public static final String JOONE_FORMAT = "joone";
    public static final String VISAD_FORMAT = "visad";
    private transient OutputStream os = null;
    private transient ObjectOutputStream oos = null;
    private String filename = "";
    private String format = "joone";

    protected void doStart() {
        try {
            this.os = new FileOutputStream(this.filename);
            this.oos = new ObjectOutputStream(this.os);
        }
        catch (IOException iOException) {
            log.warn("IOException while opening OutputStream. Message is : " + iOException.getMessage(), iOException);
        }
    }

    protected void doSnapshot() {
        if (this.oos != null) {
            if (JOONE_FORMAT.equals(this.format)) {
                this.jooneSnapshot(this.getNeuralNet());
            } else {
                this.jooneSnapshot(this.getNeuralNet());
            }
        }
    }

    private void jooneSnapshot(NeuralNet neuralNet) {
        try {
            NeuralNet neuralNet2 = neuralNet.cloneNet();
            Layer layer = neuralNet2.getInputLayer();
            if (layer != null) {
                layer.removeAllInputs();
            }
            if ((layer = neuralNet2.getOutputLayer()) != null) {
                layer.removeAllOutputs();
            }
            this.oos.writeObject(neuralNet2);
        }
        catch (IOException iOException) {
            log.warn("IOException while writing to OutputStream. Message is : " + iOException.getMessage(), iOException);
        }
    }

    protected void doStop() {
        try {
            if (this.oos != null) {
                this.oos.flush();
                this.os.close();
            }
        }
        catch (IOException iOException) {
            log.warn("IOException while closing OutputStream. Message is : " + iOException.getMessage(), iOException);
        }
    }

    public void setFilename(String string) {
        this.filename = string;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String string) {
        this.format = string;
    }

    protected void manageStopError(Monitor monitor, String string) {
    }
}

