/*
 * Decompiled with CFR 0.152.
 */
package org.joone.util;

import java.util.Vector;
import org.joone.engine.Pattern;
import org.joone.engine.RbfGaussianLayer;
import org.joone.engine.RbfGaussianParameters;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;
import org.joone.util.ConverterPlugIn;

public class RbfRandomCenterSelector
extends ConverterPlugIn {
    private static final ILogger log = LoggerFactory.getLogger(RbfRandomCenterSelector.class);
    private RbfGaussianLayer theRbfGaussianLayer;
    private Vector thePatterns = null;

    public RbfRandomCenterSelector(RbfGaussianLayer rbfGaussianLayer) {
        this.theRbfGaussianLayer = rbfGaussianLayer;
        this.setAdvancedSerieSelector("1");
    }

    protected boolean convert(int n) {
        if (this.thePatterns == null) {
            this.thePatterns = this.getInputVector();
        }
        return false;
    }

    public RbfGaussianParameters[] getGaussianParameters() {
        if (this.thePatterns.size() < this.theRbfGaussianLayer.getRows()) {
            log.warn("There are more neurons in RBF layer than training patterns -> not all nodes in RBF layer will be assigned a unique center.");
        }
        int[] nArray = new int[this.theRbfGaussianLayer.getRows()];
        for (int i = 0; i < this.theRbfGaussianLayer.getRows(); ++i) {
            int n = (int)(Math.random() * (double)this.thePatterns.size());
            if (i < this.thePatterns.size()) {
                boolean bl = true;
                do {
                    if (!bl) {
                        n = (int)(Math.random() * (double)this.thePatterns.size());
                        bl = true;
                    }
                    for (int j = 0; j < i; ++j) {
                        if (nArray[j] != n) continue;
                        bl = false;
                    }
                } while (!bl);
            }
            nArray[i] = n;
        }
        double d = this.getMaxDistance(this.thePatterns, nArray);
        double d2 = d / Math.sqrt(2 * this.theRbfGaussianLayer.getRows());
        RbfGaussianParameters[] rbfGaussianParametersArray = new RbfGaussianParameters[this.theRbfGaussianLayer.getRows()];
        for (int i = 0; i < this.theRbfGaussianLayer.getRows(); ++i) {
            double[] dArray = (double[])((Pattern)this.thePatterns.get(nArray[i])).getArray().clone();
            rbfGaussianParametersArray[i] = new RbfGaussianParameters(dArray, d2);
        }
        return rbfGaussianParametersArray;
    }

    protected double getMaxDistance(Vector vector, int[] nArray) {
        double d = -1.0;
        for (int i = 0; i < nArray.length - 1; ++i) {
            for (int j = i + 1; j < nArray.length; ++j) {
                double d2 = this.getDistance((Pattern)vector.get(nArray[i]), (Pattern)vector.get(nArray[j]));
                if (!(d2 > d)) continue;
                d = d2;
            }
        }
        return d;
    }

    protected double getDistance(Pattern pattern, Pattern pattern2) {
        double d = 0.0;
        for (int i = 0; i < pattern.getArray().length; ++i) {
            double d2 = pattern.getArray()[i] - pattern2.getArray()[i];
            d += d2 * d2;
        }
        return Math.sqrt(d);
    }
}

