/*
 * Decompiled with CFR 0.152.
 */
package org.joone.util;

import java.io.Serializable;
import org.joone.engine.Monitor;
import org.joone.engine.NeuralNetEvent;
import org.joone.engine.NeuralNetListener;
import org.joone.net.NeuralNet;

public abstract class MonitorPlugin
implements Serializable,
NeuralNetListener {
    private String name;
    private static final long serialVersionUID = 951079164859904152L;
    private int rate = 1;
    private NeuralNet neuralNet;

    public void cicleTerminated(NeuralNetEvent neuralNetEvent) {
        Monitor monitor = (Monitor)neuralNetEvent.getSource();
        if (this.toBeManaged(monitor)) {
            this.manageCycle(monitor);
        }
    }

    public void netStopped(NeuralNetEvent neuralNetEvent) {
        Monitor monitor = (Monitor)neuralNetEvent.getSource();
        this.manageStop(monitor);
    }

    public void netStarted(NeuralNetEvent neuralNetEvent) {
        Monitor monitor = (Monitor)neuralNetEvent.getSource();
        this.manageStart(monitor);
    }

    public void errorChanged(NeuralNetEvent neuralNetEvent) {
        Monitor monitor = (Monitor)neuralNetEvent.getSource();
        if (this.toBeManaged(monitor)) {
            this.manageError(monitor);
        }
    }

    public void netStoppedError(NeuralNetEvent neuralNetEvent, String string) {
        Monitor monitor = (Monitor)neuralNetEvent.getSource();
        this.manageStopError(monitor, string);
    }

    protected boolean toBeManaged(Monitor monitor) {
        if (this.getRate() == 0) {
            return false;
        }
        int n = monitor.getTotCicles() - monitor.getCurrentCicle() + 1;
        int n2 = n / this.getRate();
        return n2 * this.getRate() == n;
    }

    protected abstract void manageStop(Monitor var1);

    protected abstract void manageCycle(Monitor var1);

    protected abstract void manageStart(Monitor var1);

    protected abstract void manageError(Monitor var1);

    protected abstract void manageStopError(Monitor var1, String var2);

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public int getRate() {
        return this.rate;
    }

    public void setRate(int n) {
        this.rate = n;
    }

    public NeuralNet getNeuralNet() {
        return this.neuralNet;
    }

    public void setNeuralNet(NeuralNet neuralNet) {
        this.neuralNet = neuralNet;
    }
}

