/*
 * Decompiled with CFR 0.152.
 */
package org.joone.util;

import java.util.TreeSet;
import org.joone.engine.Pattern;
import org.joone.io.InputConnector;
import org.joone.io.InputSwitchSynapse;
import org.joone.io.StreamInputSynapse;
import org.joone.net.NetCheck;

public class LearningSwitch
extends InputSwitchSynapse {
    private StreamInputSynapse trainingSet;
    private StreamInputSynapse validationSet;
    private boolean validation = false;
    private static final long serialVersionUID = -2339515807277374407L;
    private int validationPatterns;
    private int trainingPatterns;

    public synchronized boolean addTrainingSet(StreamInputSynapse streamInputSynapse) {
        if (this.trainingSet != null) {
            return false;
        }
        if (super.addInputSynapse(streamInputSynapse)) {
            this.trainingSet = streamInputSynapse;
            super.setDefaultSynapse(this.trainingSet);
            super.reset();
            this.validation = false;
            return true;
        }
        return false;
    }

    public synchronized boolean addValidationSet(StreamInputSynapse streamInputSynapse) {
        if (this.validationSet != null) {
            return false;
        }
        if (super.addInputSynapse(streamInputSynapse)) {
            this.validationSet = streamInputSynapse;
            return true;
        }
        return false;
    }

    public synchronized void removeTrainingSet() {
        if (this.trainingSet != null) {
            super.removeInputSynapse(this.trainingSet.getName());
            this.trainingSet = null;
        }
    }

    public synchronized void removeValidationSet() {
        if (this.validationSet != null) {
            super.removeInputSynapse(this.validationSet.getName());
            this.validationSet = null;
        }
    }

    public Pattern fwdGet() {
        if (this.getMonitor().isValidation() && !this.getMonitor().isTrainingDataForValidation()) {
            super.setActiveSynapse(this.validationSet);
        } else {
            super.setActiveSynapse(this.trainingSet);
        }
        return super.fwdGet();
    }

    public Pattern fwdGet(InputConnector inputConnector) {
        if (this.getMonitor().isValidation() && !this.getMonitor().isTrainingDataForValidation()) {
            super.setActiveSynapse(this.validationSet);
        } else {
            super.setActiveSynapse(this.trainingSet);
        }
        return super.fwdGet(inputConnector);
    }

    public TreeSet check() {
        TreeSet treeSet = super.check();
        if (this.trainingSet == null) {
            treeSet.add(new NetCheck(0, "Training set parameter not set", this));
        }
        if (this.validationSet == null) {
            treeSet.add(new NetCheck(0, "Validation set parameter not set", this));
        }
        return treeSet;
    }

    public StreamInputSynapse getTrainingSet() {
        return this.trainingSet;
    }

    public void setTrainingSet(StreamInputSynapse streamInputSynapse) {
        this.trainingSet = streamInputSynapse;
    }

    public StreamInputSynapse getValidationSet() {
        return this.validationSet;
    }

    public void setValidationSet(StreamInputSynapse streamInputSynapse) {
        this.validationSet = streamInputSynapse;
    }
}

