/*
 * Decompiled with CFR 0.152.
 */
package org.joone.util;

import org.joone.engine.Monitor;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;
import org.joone.util.MonitorPlugin;

public class DynamicAnnealing
extends MonitorPlugin {
    private static final ILogger log = LoggerFactory.getLogger(DynamicAnnealing.class);
    private double lastError = 0.0;
    private double step = 0.0;
    private static final long serialVersionUID = -5494365758818313237L;

    protected void manageCycle(Monitor monitor) {
        double d = monitor.getGlobalError();
        if (d > this.lastError && this.lastError > 0.0 && this.step > 0.0) {
            double d2 = monitor.getLearningRate() * (1.0 - this.step / 100.0);
            monitor.setLearningRate(d2);
            int n = monitor.getTotCicles() - monitor.getCurrentCicle() + 1;
            log.info("DynamicAnnealing: changed the learning rate to " + d2 + " at cycle n." + n);
        }
        this.lastError = d;
    }

    protected void manageStop(Monitor monitor) {
    }

    public double getStep() {
        return this.step;
    }

    public void setStep(double d) {
        this.step = d;
        if (d >= 100.0) {
            this.step = 99.0;
        }
    }

    protected void manageStart(Monitor monitor) {
    }

    protected void manageError(Monitor monitor) {
    }

    protected void manageStopError(Monitor monitor, String string) {
    }
}

