/*
 * Decompiled with CFR 0.152.
 */
package org.joone.util;

import org.joone.engine.Pattern;
import org.joone.util.ConverterPlugIn;

public class DeltaNormPlugIn
extends ConverterPlugIn {
    private static final long serialVersionUID = 1698511686417955514L;
    private transient double[] probVolWin;

    protected boolean convert(int n) {
        boolean bl = false;
        int n2 = this.getSerieIndexNumber(n);
        if (this.getProbVolWin()[n2] == 0.0) {
            this.getProbVolWin()[n2] = this.calculatePVW(n2 + 1, n);
        }
        int n3 = this.getSerieSelected().length;
        for (int i = this.getInputVector().size() - 1; i >= n3; --i) {
            double d = this.getDelta(i, n2 + 1, n, false);
            Pattern pattern = (Pattern)this.getInputVector().elementAt(i);
            pattern.setValue(n, d /= this.getProbVolWin()[n2]);
            bl = true;
        }
        return bl;
    }

    protected double calculatePVW(int n, int n2) {
        int n3;
        int n4 = this.getSerieSelected().length;
        double d = 0.0;
        for (n3 = n4; n3 < this.getInputVector().size(); ++n3) {
            d += this.getDelta(n3, n, n2, true);
        }
        n3 = this.getInputVector().size() - n4;
        return (d /= (double)n3) * 2.0;
    }

    protected double getDelta(int n, int n2, int n3, boolean bl) {
        double d = this.getValuePoint(n, n3);
        double d2 = this.funcDelta(n, n2, n3);
        if (d == 0.0) {
            if (!bl) {
                return -d2 / Math.abs(d2);
            }
            return d2 / d2;
        }
        if (!bl) {
            return (d - d2) / d;
        }
        return Math.abs(d - d2) / d;
    }

    protected double funcDelta(int n, int n2, int n3) {
        return this.getValuePoint(n - n2, n3);
    }

    private double[] getProbVolWin() {
        if (this.probVolWin == null || this.probVolWin.length != this.getSerieSelected().length) {
            this.probVolWin = new double[this.getSerieSelected().length];
        }
        return this.probVolWin;
    }
}

