/*
 * Decompiled with CFR 0.152.
 */
package org.joone.util;

import java.util.StringTokenizer;
import java.util.Vector;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;

public class CSVParser {
    private String m_values;
    private boolean range_allowed = true;
    private static final ILogger log = LoggerFactory.getLogger(CSVParser.class);
    private static final char RANGE_SEPARATOR = '-';

    public CSVParser(String string) {
        this(string, true);
    }

    public CSVParser(String string, boolean bl) {
        this.m_values = string;
        this.range_allowed = bl;
    }

    public int[] parseInt() throws NumberFormatException {
        int[] nArray = null;
        Vector<Integer> vector = new Vector<Integer>();
        StringTokenizer stringTokenizer = new StringTokenizer(this.m_values, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string;
            String string2;
            String string3 = stringTokenizer.nextToken().trim();
            int n = string3.indexOf(45);
            if (n <= 0) {
                try {
                    vector.add(new Integer(Integer.parseInt(string3)));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    string2 = "Error parsing '" + this.m_values + "' : '" + string3 + "' is not a valid integer value";
                    throw new NumberFormatException(string2);
                }
            }
            if (this.range_allowed) {
                string = string3.substring(0, n);
                string2 = string3.substring(n + 1);
                try {
                    int n2;
                    int n3 = Integer.parseInt(string);
                    int n4 = Integer.parseInt(string2);
                    if (n3 > n4) {
                        n2 = n4;
                        n4 = n3;
                        n3 = n2;
                    }
                    for (n2 = n3; n2 <= n4; ++n2) {
                        vector.add(new Integer(n2));
                    }
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    String string4 = "Error parsing '" + this.m_values + "' : '" + string3 + "' contains not valid integer values";
                    throw new NumberFormatException(string4);
                }
            }
            string = "Error parsing '" + this.m_values + "' : range not allowed";
            throw new NumberFormatException(string);
        }
        nArray = new int[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            nArray[i] = (Integer)vector.elementAt(i);
        }
        return nArray;
    }

    public double[] parseDouble() throws NumberFormatException {
        Vector<Double> vector = new Vector<Double>();
        StringTokenizer stringTokenizer = new StringTokenizer(this.m_values, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken().trim();
            int n = string.indexOf(45);
            if (n <= 0) {
                try {
                    vector.add(new Double(Double.parseDouble(string)));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    String string2 = "Error parsing '" + this.m_values + "' : '" + string + "' is not a valid numeric value";
                    throw new NumberFormatException(string2);
                }
            }
            String string3 = "Error parsing '" + this.m_values + "' : range not allowed for not integer values";
            throw new NumberFormatException(string3);
        }
        double[] dArray = new double[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            dArray[i] = (Double)vector.elementAt(i);
        }
        return dArray;
    }

    public static void main(String[] stringArray) {
        CSVParser cSVParser = new CSVParser("1.0,-3.6,1.4,15");
        double[] dArray = cSVParser.parseDouble();
        log.debug("Double values:");
        if (dArray != null) {
            for (int i = 0; i < dArray.length; ++i) {
                log.debug("array[" + i + "] = " + dArray[i]);
            }
        }
        cSVParser = new CSVParser("1,-3,4-8,11");
        int[] nArray = cSVParser.parseInt();
        log.debug("Integer values:");
        if (nArray != null) {
            for (int i = 0; i < nArray.length; ++i) {
                log.debug("array[" + i + "] = " + nArray[i]);
            }
        }
    }
}

