/*
 * Decompiled with CFR 0.152.
 */
package org.joone.structure;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.joone.engine.Layer;
import org.joone.engine.Matrix;
import org.joone.engine.NeuralElement;
import org.joone.engine.NeuralNetEvent;
import org.joone.engine.NeuralNetListener;
import org.joone.engine.OutputPatternListener;
import org.joone.engine.Synapse;
import org.joone.engine.listeners.ConvergenceEvent;
import org.joone.engine.listeners.ConvergenceListener;
import org.joone.engine.listeners.ConvergenceObserver;
import org.joone.exception.JooneRuntimeException;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;
import org.joone.net.NeuralNet;
import org.joone.net.NeuralNetValidator;
import org.joone.net.NeuralValidationEvent;
import org.joone.net.NeuralValidationListener;
import org.joone.structure.PatternForwardedSynapse;

public class Nakayama
implements NeuralNetListener,
NeuralValidationListener,
ConvergenceListener,
Serializable {
    private static final ILogger log = LoggerFactory.getLogger(Nakayama.class);
    private static final int NO_REMOVE = 0;
    private static final int INFO_REMOVE = 1;
    private static final int VARIANCE_REMOVE = 2;
    private static final int CORRELATION_POSSIBLE_REMOVE = 3;
    private static final int CORRELATION_REMOVE = 4;
    private static final int REMOVE_DONE = -1;
    private List layers = new ArrayList();
    private boolean isRunning;
    private NeuralNet net;
    private NeuralNet clone;
    private double epsilon = 0.05;
    private List listeners = new ArrayList();
    private List outputsAfterPattern;
    private List information;
    private double infoMax;
    private List averageOutputs;
    private List variance;
    private double varianceMax;
    private List gamma;
    private boolean optimized = false;

    public Nakayama(NeuralNet neuralNet) {
        this.net = neuralNet;
    }

    public void addLayer(Layer layer) {
        this.layers.add(layer);
    }

    public void addLayers(NeuralNet neuralNet) {
        for (int i = 0; i < neuralNet.getLayers().size(); ++i) {
            Object e = neuralNet.getLayers().get(i);
            if (e == neuralNet.getInputLayer() || e == neuralNet.getOutputLayer()) continue;
            this.layers.add(e);
        }
    }

    public boolean optimize() {
        this.outputsAfterPattern = new ArrayList();
        this.information = new ArrayList();
        this.infoMax = 0.0;
        this.averageOutputs = new ArrayList();
        this.variance = new ArrayList();
        this.varianceMax = 0.0;
        this.gamma = new ArrayList();
        this.optimized = false;
        log.debug("Optimization request [cycle : " + this.net.getMonitor().getCurrentCicle() + "]");
        this.isRunning = this.net.isRunning();
        if (this.isRunning) {
            log.debug("Stopping network...");
            this.removeAllListeners();
            this.net.addNeuralNetListener(this);
            this.net.getMonitor().Stop();
        } else {
            this.runValidation();
        }
        return this.optimized;
    }

    protected void runValidation() {
        this.net.getMonitor().setExporting(true);
        this.clone = this.net.cloneNet();
        this.net.getMonitor().setExporting(false);
        this.clone.removeAllListeners();
        this.clone.getOutputLayer().addOutputSynapse(new PatternForwardedSynapse(this));
        log.debug("Validating network...");
        NeuralNetValidator neuralNetValidator = new NeuralNetValidator(this.clone);
        neuralNetValidator.addValidationListener(this);
        neuralNetValidator.useTrainingData(true);
        neuralNetValidator.start();
    }

    protected void doOptimize() {
        log.debug("Optimizing...");
        this.evaluateNeurons();
        this.selectNeurons();
        log.debug("Optimization done.");
        this.cleanUp();
        for (int i = 0; i < this.net.getLayers().size(); ++i) {
            Layer layer = (Layer)this.net.getLayers().get(i);
            log.debug("Layer [" + layer.getClass().getName() + "] - neurons : " + layer.getRows());
        }
    }

    protected void cleanUp() {
        log.debug("Cleaning up...");
        this.outputsAfterPattern = null;
        this.information = null;
        this.averageOutputs = null;
        this.variance = null;
        this.gamma = null;
        this.clone = null;
        for (int i = 0; i < this.layers.size(); ++i) {
            Layer layer = (Layer)this.layers.get(i);
            if (layer.getRows() != 0) continue;
            log.debug("Remove layer [" + layer.getClass().getName() + "]");
            this.net.removeLayer(layer);
            this.layers.remove(i);
            --i;
        }
        this.net.removeNeuralNetListener(this);
        this.restoreAllListeners();
        log.debug("Clean ;)");
        if (this.isRunning) {
            log.debug("Restarting net...");
            this.net.start();
            this.net.getMonitor().runAgain();
        }
    }

    protected void selectNeurons() {
        int n;
        double[] dArray;
        int n2;
        int[] nArray;
        log.debug("Selecting neurons...");
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        ArrayList<double[]> arrayList2 = new ArrayList<double[]>();
        for (int i = 0; i < this.layers.size(); ++i) {
            Layer layer = (Layer)this.layers.get(i);
            nArray = new int[layer.getRows()];
            for (n2 = 0; n2 < layer.getRows(); ++n2) {
                double d;
                double d2 = ((double[])this.information.get(i))[n2] / this.infoMax;
                if (!(d2 * (d = ((double[])this.variance.get(i))[n2] / this.varianceMax) * (dArray = this.getMinCorrelation(i, n2))[0] <= this.epsilon)) continue;
                if (d2 <= d && d2 <= dArray[0]) {
                    nArray[n2] = 1;
                    continue;
                }
                if (d < d2 && d <= dArray[0]) {
                    nArray[n2] = 2;
                    continue;
                }
                nArray[n2] = 3;
                arrayList2.add(dArray);
            }
            arrayList.add(nArray);
        }
        ArrayList<int[]> arrayList3 = new ArrayList<int[]>();
        for (n = 0; n < arrayList2.size(); ++n) {
            dArray = (double[])arrayList2.get(n);
            if (dArray[5] < 0.0 && ((int[])arrayList.get((int)dArray[1]))[(int)dArray[2]] == 3) {
                n2 = ((int[])arrayList.get((int)dArray[3]))[(int)dArray[4]];
                if (n2 == 1 || n2 == 2 || n2 == 4) {
                    ((int[])arrayList.get((int)((int)dArray[1])))[(int)dArray[2]] = 0;
                    continue;
                }
                if (((double[])this.variance.get((int)dArray[1]))[(int)dArray[2]] <= ((double[])this.variance.get((int)dArray[3]))[(int)dArray[4]]) {
                    ((int[])arrayList.get((int)((int)dArray[1])))[(int)dArray[2]] = 4;
                    arrayList3.add(new int[]{(int)dArray[1], (int)dArray[2], (int)dArray[3], (int)dArray[4]});
                    continue;
                }
                ((int[])arrayList.get((int)((int)dArray[1])))[(int)dArray[2]] = 0;
                ((int[])arrayList.get((int)((int)dArray[3])))[(int)dArray[4]] = 4;
                arrayList3.add(new int[]{(int)dArray[3], (int)dArray[4], (int)dArray[1], (int)dArray[2]});
                continue;
            }
            if (!(dArray[5] > 0.0) || ((int[])arrayList.get((int)dArray[3]))[(int)dArray[4]] != 3) continue;
            n2 = ((int[])arrayList.get((int)dArray[1]))[(int)dArray[2]];
            if (n2 == 1 || n2 == 2 || n2 == 4) {
                ((int[])arrayList.get((int)((int)dArray[3])))[(int)dArray[4]] = 0;
                continue;
            }
            if (((double[])this.variance.get((int)dArray[1]))[(int)dArray[2]] >= ((double[])this.variance.get((int)dArray[3]))[(int)dArray[4]]) {
                ((int[])arrayList.get((int)((int)dArray[3])))[(int)dArray[4]] = 4;
                arrayList3.add(new int[]{(int)dArray[3], (int)dArray[4], (int)dArray[1], (int)dArray[2]});
                continue;
            }
            ((int[])arrayList.get((int)((int)dArray[3])))[(int)dArray[4]] = 0;
            ((int[])arrayList.get((int)((int)dArray[1])))[(int)dArray[2]] = 4;
            arrayList3.add(new int[]{(int)dArray[1], (int)dArray[2], (int)dArray[3], (int)dArray[4]});
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            nArray = (int[])arrayList.get(i);
            n = 0;
            for (int j = 0; j < nArray.length; ++j) {
                if (nArray[j] == 1) {
                    log.debug("Remove[info]: " + i + " " + j);
                    this.removeNeuron(i, n);
                    this.optimized = true;
                    nArray[j] = -1;
                    continue;
                }
                if (nArray[j] == 2) {
                    log.debug("Remove[variance]: " + i + " " + j);
                    this.weightsUpdateVariance(i, j, n);
                    this.removeNeuron(i, n);
                    this.optimized = true;
                    nArray[j] = -1;
                    continue;
                }
                if (nArray[j] == 4) {
                    log.debug("Remove[correlation]: " + i + " " + j);
                    this.weightsUpdateCorrelation(arrayList, arrayList3, i, j);
                    this.removeNeuron(i, n);
                    this.optimized = true;
                    nArray[j] = -1;
                    continue;
                }
                if (nArray[j] != 0) continue;
                ++n;
            }
        }
        log.debug("Selection done.");
    }

    protected void weightsUpdateCorrelation(List list, List list2, int n, int n2) {
        int[] nArray = null;
        int[] nArray2 = this.findCorrelation(list2, n, n2);
        while (nArray2 != null) {
            nArray = nArray2;
            nArray2 = this.findCorrelation(list2, nArray[0], nArray[1]);
        }
        int n3 = this.findIndex(list, n, n2);
        int n4 = this.findIndex(list, nArray[0], nArray[1]);
        double d = (double)(this.getGamma(n, n2, nArray[0], nArray[1]) >= 0.0 ? 1 : -1) * Math.sqrt(((double[])this.variance.get(n))[n2] / ((double[])this.variance.get(n))[nArray[1]]);
        Synapse synapse = null;
        Layer layer = (Layer)this.layers.get(n);
        Layer layer2 = (Layer)this.layers.get(nArray[0]);
        if (layer.getAllOutputs().size() != layer2.getAllInputs().size()) {
            throw new JooneRuntimeException("Unable to optimize. #output layers for neuron and correlated neuron are not equal.");
        }
        for (int i = 0; i < layer.getAllOutputs().size(); ++i) {
            int n5;
            NeuralElement neuralElement = (NeuralElement)layer.getAllOutputs().get(i);
            if (!(neuralElement instanceof Synapse)) {
                throw new JooneRuntimeException("Unable to optimize. Output of layer is not a synapse.");
            }
            Synapse synapse2 = (Synapse)neuralElement;
            Layer layer3 = this.findOutputLayer(synapse2);
            for (n5 = 0; n5 < layer2.getAllOutputs().size() && synapse == null; ++n5) {
                NeuralElement neuralElement2 = (NeuralElement)layer2.getAllOutputs().get(n5);
                if (!(neuralElement2 instanceof Synapse) || this.findOutputLayer(synapse = (Synapse)neuralElement2) == layer3) continue;
                synapse = null;
            }
            if (synapse == null) {
                throw new JooneRuntimeException("Unable to optimize. Unable to find same output layer for correlated layer.");
            }
            Matrix matrix = layer3.getBias();
            Matrix matrix2 = synapse2.getWeights();
            Matrix matrix3 = synapse.getWeights();
            for (n5 = 0; n5 < layer3.getRows(); ++n5) {
                double[] dArray = matrix.value[n5];
                dArray[0] = dArray[0] + matrix2.value[n3][n5] * (((double[])this.averageOutputs.get(n))[n2] - d * ((double[])this.averageOutputs.get(nArray[0]))[nArray[1]]);
                matrix.delta[n5][0] = 0.0;
                double[] dArray2 = matrix3.value[n4];
                int n6 = n5;
                dArray2[n6] = dArray2[n6] + matrix2.value[n3][n5];
                matrix3.delta[n4][n5] = 0.0;
            }
        }
    }

    protected double getGamma(int n, int n2, int n3, int n4) {
        if (n > n3 || n == n3 && n2 > n4) {
            int n5 = n;
            int n6 = n2;
            n = n3;
            n2 = n4;
            n3 = n5;
            n4 = n6;
        }
        return ((double[])((List[])this.gamma.get(n))[n2].get(n3))[n4];
    }

    protected int findIndex(List list, int n, int n2) {
        int[] nArray = (int[])list.get(n);
        int n3 = n2;
        for (int i = 0; i < n2; ++i) {
            if (nArray[i] != -1) continue;
            --n3;
        }
        return n3;
    }

    protected int[] findCorrelation(List list, int n, int n2) {
        for (int i = 0; i < list.size(); ++i) {
            int[] nArray = (int[])list.get(i);
            if (nArray[0] != n || nArray[1] != n2) continue;
            return new int[]{nArray[2], nArray[3]};
        }
        return null;
    }

    protected void weightsUpdateVariance(int n, int n2, int n3) {
        Layer layer = (Layer)this.layers.get(n);
        for (int i = 0; i < layer.getAllOutputs().size(); ++i) {
            NeuralElement neuralElement = (NeuralElement)layer.getAllOutputs().get(i);
            if (!(neuralElement instanceof Synapse)) {
                throw new JooneRuntimeException("Unable to optimize. Output of layer is not a synapse.");
            }
            Synapse synapse = (Synapse)neuralElement;
            Layer layer2 = this.findOutputLayer(synapse);
            Matrix matrix = layer2.getBias();
            Matrix matrix2 = synapse.getWeights();
            double d = ((double[])this.averageOutputs.get(n))[n2];
            for (int j = 0; j < layer2.getRows(); ++j) {
                double[] dArray = matrix.value[j];
                dArray[0] = dArray[0] + matrix2.value[n3][j] * d;
                matrix.delta[j][0] = 0.0;
            }
        }
    }

    protected void removeNeuron(int n, int n2) {
        Layer layer = (Layer)this.layers.get(n);
        if (layer.getRows() > 1) {
            Matrix matrix;
            Synapse synapse;
            NeuralElement neuralElement;
            int n3;
            for (n3 = 0; n3 < layer.getAllInputs().size(); ++n3) {
                neuralElement = (NeuralElement)layer.getAllInputs().get(n3);
                if (!(neuralElement instanceof Synapse)) {
                    throw new JooneRuntimeException("Unable to optimize. Input of layer is not a synapse.");
                }
                synapse = (Synapse)neuralElement;
                matrix = synapse.getWeights();
                matrix.removeColumn(n2);
                synapse.setOutputDimension(synapse.getOutputDimension() - 1);
                synapse.setWeights(matrix);
            }
            for (n3 = 0; n3 < layer.getAllOutputs().size(); ++n3) {
                neuralElement = (NeuralElement)layer.getAllOutputs().get(n3);
                if (!(neuralElement instanceof Synapse)) {
                    throw new JooneRuntimeException("Unable to optimize. Output of layer is not a synapse.");
                }
                synapse = (Synapse)neuralElement;
                matrix = synapse.getWeights();
                matrix.removeRow(n2);
                synapse.setInputDimension(synapse.getInputDimension() - 1);
                synapse.setWeights(matrix);
            }
            matrix = layer.getBias();
            matrix.removeRow(n2);
            layer.setRows(layer.getRows() - 1);
            layer.setBias(matrix);
        } else {
            Layer layer2;
            Synapse synapse;
            NeuralElement neuralElement;
            int n4;
            for (n4 = 0; n4 < layer.getAllInputs().size(); ++n4) {
                neuralElement = (NeuralElement)layer.getAllInputs().get(n4);
                if (!(neuralElement instanceof Synapse)) {
                    throw new JooneRuntimeException("Unable to optimize. Input of layer is not a synapse.");
                }
                synapse = (Synapse)neuralElement;
                layer2 = this.findInputLayer(synapse);
                layer2.removeOutputSynapse(synapse);
            }
            for (n4 = 0; n4 < layer.getAllOutputs().size(); ++n4) {
                neuralElement = (NeuralElement)layer.getAllOutputs().get(n4);
                if (!(neuralElement instanceof Synapse)) {
                    throw new JooneRuntimeException("Unable to optimize. Output of layer is not a synapse.");
                }
                synapse = (Synapse)neuralElement;
                layer2 = this.findOutputLayer(synapse);
                layer2.removeInputSynapse(synapse);
            }
            Matrix matrix = layer.getBias();
            matrix.removeRow(n2);
            layer.setRows(layer.getRows() - 1);
            layer.setBias(matrix);
        }
    }

    protected Layer findInputLayer(Synapse synapse) {
        for (int i = 0; i < this.net.getLayers().size(); ++i) {
            Layer layer = (Layer)this.net.getLayers().get(i);
            if (!layer.getAllOutputs().contains(synapse)) continue;
            return layer;
        }
        return null;
    }

    protected Layer findOutputLayer(Synapse synapse) {
        for (int i = 0; i < this.net.getLayers().size(); ++i) {
            Layer layer = (Layer)this.net.getLayers().get(i);
            if (!layer.getAllInputs().contains(synapse)) continue;
            return layer;
        }
        return null;
    }

    protected void evaluateNeurons() {
        List list;
        Layer layer;
        log.debug("Evaluation of neurons...");
        int n = this.net.getMonitor().getTrainingPatterns();
        for (int i = 0; i < this.layers.size(); ++i) {
            layer = (Layer)this.layers.get(i);
            double[] dArray = new double[layer.getRows()];
            double[] dArray2 = new double[layer.getRows()];
            for (int j = 0; j < layer.getRows(); ++j) {
                double d = this.getSumAbsoluteWeights(layer, j);
                double[] dArray3 = this.getSumOutputs(i, j);
                dArray[j] = d * dArray3[1] / (double)n;
                if (dArray[j] > this.infoMax) {
                    this.infoMax = dArray[j];
                }
                dArray2[j] = dArray3[0] / (double)n;
            }
            this.information.add(dArray);
            this.averageOutputs.add(dArray2);
        }
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < this.layers.size(); ++i) {
            int n2;
            layer = (Layer)this.layers.get(i);
            double[] dArray = new double[layer.getRows()];
            ArrayList<double[]> arrayList2 = new ArrayList<double[]>();
            for (n2 = 0; n2 < this.outputsAfterPattern.size(); ++n2) {
                double[] dArray4 = new double[layer.getRows()];
                for (int j = 0; j < layer.getRows(); ++j) {
                    list = (List)this.outputsAfterPattern.get(n2);
                    dArray4[j] = ((double[])list.get(i))[j] - ((double[])this.averageOutputs.get(i))[j];
                    int n3 = j;
                    dArray[n3] = dArray[n3] + dArray4[j] * dArray4[j];
                }
                arrayList2.add(dArray4);
            }
            for (n2 = 0; n2 < layer.getRows(); ++n2) {
                if (!(dArray[n2] > this.varianceMax)) continue;
                this.varianceMax = dArray[n2];
            }
            arrayList.add(arrayList2);
            this.variance.add(dArray);
        }
        for (int i = 0; i < this.layers.size(); ++i) {
            Layer layer2 = (Layer)this.layers.get(i);
            List[] listArray = new List[layer2.getRows()];
            this.gamma.add(listArray);
            for (int j = 0; j < layer2.getRows(); ++j) {
                listArray[j] = new ArrayList();
                for (int k = 0; k < this.layers.size(); ++k) {
                    int n4;
                    Layer layer3 = (Layer)this.layers.get(k);
                    if (k < i) {
                        listArray[j].add(new double[0]);
                        continue;
                    }
                    double[] dArray = new double[layer3.getRows()];
                    listArray[j].add(dArray);
                    int n5 = n4 = i == k ? j + 1 : 0;
                    while (n4 < layer3.getRows()) {
                        double d = 0.0;
                        double d2 = 0.0;
                        for (int i2 = 0; i2 < n; ++i2) {
                            List list2 = (List)arrayList.get(i);
                            list = (List)arrayList.get(k);
                            d += ((double[])list2.get(i2))[j] * ((double[])list.get(i2))[n4];
                        }
                        d2 = ((double[])this.variance.get(i))[j] * ((double[])this.variance.get(k))[n4];
                        dArray[n4] = d / Math.sqrt(d2);
                        ++n4;
                    }
                }
            }
        }
        log.debug("Evaluation done.");
    }

    protected double[] getMinCorrelation(int n, int n2) {
        double d;
        double[] dArray = new double[]{2.0, -1.0, -1.0, -1.0, -1.0, 0.0};
        for (int i = 0; i <= n; ++i) {
            List[] listArray = (List[])this.gamma.get(i);
            for (int j = 0; j < (i == n ? n2 : listArray.length); ++j) {
                d = 1.0 - Math.abs(((double[])listArray[j].get(n))[n2]);
                if (!(dArray[0] > d)) continue;
                dArray[0] = d;
                dArray[1] = i;
                dArray[2] = j;
                dArray[3] = n;
                dArray[4] = n2;
                dArray[5] = 1.0;
            }
        }
        List list = ((List[])this.gamma.get(n))[n2];
        for (int i = n; i < list.size(); ++i) {
            int n3;
            double[] dArray2 = (double[])list.get(i);
            int n4 = n3 = i == n ? n2 + 1 : 0;
            while (n3 < dArray2.length) {
                d = 1.0 - Math.abs(dArray2[n3]);
                if (dArray[0] > d) {
                    dArray[0] = d;
                    dArray[1] = n;
                    dArray[2] = n2;
                    dArray[3] = i;
                    dArray[4] = n3;
                    dArray[5] = -1.0;
                }
                ++n3;
            }
        }
        return dArray;
    }

    protected double[] getSumOutputs(int n, int n2) {
        double[] dArray = new double[2];
        for (int i = 0; i < this.outputsAfterPattern.size(); ++i) {
            List list = (List)this.outputsAfterPattern.get(i);
            double d = ((double[])list.get(n))[n2];
            dArray[0] = dArray[0] + d;
            dArray[1] = dArray[1] + Math.abs(d);
        }
        return dArray;
    }

    protected double getSumAbsoluteWeights(Layer layer, int n) {
        double d = 0.0;
        for (int i = 0; i < layer.getAllOutputs().size(); ++i) {
            OutputPatternListener outputPatternListener = (OutputPatternListener)layer.getAllOutputs().get(i);
            if (!(outputPatternListener instanceof Synapse)) {
                throw new JooneRuntimeException("Unable to optimize. Output of layer is not a synapse.");
            }
            Synapse synapse = (Synapse)outputPatternListener;
            for (int j = 0; j < synapse.getOutputDimension(); ++j) {
                d += Math.abs(synapse.getWeights().value[n][j]);
            }
        }
        return d;
    }

    public void cicleTerminated(NeuralNetEvent neuralNetEvent) {
    }

    public void errorChanged(NeuralNetEvent neuralNetEvent) {
    }

    public void netStarted(NeuralNetEvent neuralNetEvent) {
    }

    public void netStopped(NeuralNetEvent neuralNetEvent) {
        log.debug("Network stopped.");
        this.runValidation();
    }

    public void netStoppedError(NeuralNetEvent neuralNetEvent, String string) {
    }

    public void netValidated(NeuralValidationEvent neuralValidationEvent) {
        log.debug("Network validated.");
        this.doOptimize();
    }

    protected void removeAllListeners() {
        Vector vector = this.net.getListeners();
        while (vector.size() > 0) {
            NeuralNetListener neuralNetListener = (NeuralNetListener)vector.get(vector.size() - 1);
            this.listeners.add(neuralNetListener);
            this.net.removeNeuralNetListener(neuralNetListener);
        }
    }

    protected void restoreAllListeners() {
        for (NeuralNetListener neuralNetListener : this.listeners) {
            this.net.addNeuralNetListener(neuralNetListener);
        }
        this.listeners = new Vector();
    }

    void patternFinished() {
        ArrayList<double[]> arrayList = new ArrayList<double[]>();
        for (int i = 0; i < this.layers.size(); ++i) {
            Layer layer = this.findClonedLayer((Layer)this.layers.get(i));
            arrayList.add(layer.getLastOutputs());
        }
        this.outputsAfterPattern.add(arrayList);
    }

    private Layer findClonedLayer(Layer layer) {
        for (int i = 0; i < this.net.getLayers().size(); ++i) {
            if (this.net.getLayers().get(i) != layer) continue;
            return (Layer)this.clone.getLayers().get(i);
        }
        return null;
    }

    public double getEpsilon() {
        return this.epsilon;
    }

    public void setEpsilon(double d) {
        this.epsilon = d;
    }

    public void netConverged(ConvergenceEvent convergenceEvent, ConvergenceObserver convergenceObserver) {
        if (!this.optimize()) {
            convergenceObserver.disableCurrentConvergence();
        }
    }
}

