/*
 * Decompiled with CFR 0.152.
 */
package org.joone.script;

import bsh.EvalError;
import bsh.Interpreter;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;

public class JooneScript {
    private static final ILogger log = LoggerFactory.getLogger(JooneScript.class);
    private Interpreter jShell;

    private Interpreter getShell() {
        if (this.jShell == null) {
            this.jShell = new Interpreter();
            try {
                this.jShell.eval("import org.joone.engine.*;");
                this.jShell.eval("import org.joone.engine.learning.*;");
                this.jShell.eval("import org.joone.edit.*;");
                this.jShell.eval("import org.joone.util.*;");
                this.jShell.eval("import org.joone.net.*;");
                this.jShell.eval("import org.joone.io.*;");
                this.jShell.eval("import org.joone.script.*;");
            }
            catch (EvalError evalError) {
                log.error("EvalError thrown. Message is " + evalError.getMessage(), evalError);
                return null;
            }
        }
        return this.jShell;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.out.println("Usage: java org.joone.script.JooneScript <script_file>");
        } else {
            JooneScript jooneScript = new JooneScript();
            jooneScript.source(stringArray[0]);
        }
    }

    public void source(String string) {
        try {
            this.getShell().source(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            log.error("FileNotFoundException thrown. Message is : " + fileNotFoundException.getMessage(), fileNotFoundException);
        }
        catch (IOException iOException) {
            log.error("IOException thrown. Message is : " + iOException.getMessage(), iOException);
        }
        catch (EvalError evalError) {
            log.warn("EvalError thrown. Message is : " + evalError.getMessage(), evalError);
            System.out.println("Invalid BeanShell code!");
        }
    }

    public void eval(String string) {
        try {
            this.getShell().eval(string);
        }
        catch (EvalError evalError) {
            log.warn("Error while evaluating. Message is : " + evalError.getMessage(), evalError);
            System.out.println("Invalid BeanShell code!");
            evalError.printStackTrace();
        }
    }

    public void set(String string, Object object) {
        try {
            this.getShell().set(string, object);
        }
        catch (EvalError evalError) {
            evalError.printStackTrace();
        }
    }
}

