/*
 * Decompiled with CFR 0.152.
 */
package org.joone.samples.util;

import org.joone.exception.JooneRuntimeException;
import org.joone.io.MemoryInputTokenizer;
import org.joone.io.StreamInputSynapse;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;

public class ParityInputSynapse
extends StreamInputSynapse {
    private static final ILogger log = LoggerFactory.getLogger(ParityInputSynapse.class);
    private int paritySize = 2;
    private double upperBit = 1.0;
    private double lowerBit = 0.0;

    protected void initInputStream() throws JooneRuntimeException {
        this.setAdvancedColumnSelector("1-" + (this.paritySize + 1));
        this.setTokens(new MemoryInputTokenizer(this.createParityArray()));
    }

    public void setParitySize(int n) {
        this.paritySize = n;
    }

    public int getParitySize() {
        return this.paritySize;
    }

    public int getNumOfPatterns() {
        return (int)Math.pow(2.0, this.paritySize);
    }

    protected double[][] createParityArray() {
        int n = this.getNumOfPatterns();
        double[][] dArray = new double[n][this.paritySize + 1];
        for (int i = 0; i < n; ++i) {
            int n2 = 0;
            int n3 = i;
            for (int j = 0; j < this.paritySize; ++j) {
                int n4 = n3 % 2;
                n3 /= 2;
                if (n4 == 1) {
                    n2 = (n2 + 1) % 2;
                }
                dArray[i][j] = n4 == 0 ? this.getLowerBit() : this.getUpperBit();
            }
            dArray[i][this.paritySize] = n2 == 0 ? this.getLowerBit() : this.getUpperBit();
        }
        return dArray;
    }

    public void setUpperBit(double d) {
        this.upperBit = d;
    }

    public double getUpperBit() {
        return this.upperBit;
    }

    public void setLowerBit(double d) {
        this.lowerBit = d;
    }

    public double getLowerBit() {
        return this.lowerBit;
    }
}

