/*
 * Decompiled with CFR 0.152.
 */
package org.joone.samples.engine.xor.rbf;

import org.joone.engine.BiasedLinearLayer;
import org.joone.engine.FullSynapse;
import org.joone.engine.InputPatternListener;
import org.joone.engine.LinearLayer;
import org.joone.engine.Monitor;
import org.joone.engine.NeuralNetEvent;
import org.joone.engine.NeuralNetListener;
import org.joone.engine.OutputPatternListener;
import org.joone.engine.RbfGaussianLayer;
import org.joone.engine.RbfGaussianParameters;
import org.joone.engine.RbfInputSynapse;
import org.joone.engine.learning.ComparingElement;
import org.joone.engine.learning.TeachingSynapse;
import org.joone.io.MemoryInputSynapse;
import org.joone.io.MemoryOutputSynapse;
import org.joone.net.NeuralNet;

public class XOR_static_RBF
implements NeuralNetListener {
    private NeuralNet nnet = null;
    RbfGaussianLayer hidden = null;
    private MemoryInputSynapse inputSynapse;
    private MemoryInputSynapse desiredOutputSynapse;
    private MemoryOutputSynapse outputSynapse;
    private boolean randomCenters = false;
    private double[][] inputArray = new double[][]{{0.0, 0.0}, {0.0, 1.0}, {1.0, 0.0}, {1.0, 1.0}};
    private double[][] desiredOutputArray = new double[][]{{1.0}, {0.0}, {0.0}, {1.0}};

    public static void main(String[] stringArray) {
        XOR_static_RBF xOR_static_RBF = new XOR_static_RBF();
        xOR_static_RBF.initNeuralNet();
        xOR_static_RBF.train();
        xOR_static_RBF.test();
    }

    public void train() {
        this.inputSynapse.setInputArray(this.inputArray);
        this.inputSynapse.setAdvancedColumnSelector("1,2");
        this.desiredOutputSynapse.setInputArray(this.desiredOutputArray);
        this.desiredOutputSynapse.setAdvancedColumnSelector("1");
        Monitor monitor = this.nnet.getMonitor();
        monitor.setLearningRate(0.3);
        monitor.setMomentum(0.8);
        monitor.setTrainingPatterns(this.inputArray.length);
        monitor.setTotCicles(200);
        monitor.setLearning(true);
        this.nnet.addNeuralNetListener(this);
        this.nnet.go(true);
    }

    protected void initNeuralNet() {
        Object object;
        Object object2;
        RbfGaussianParameters[] rbfGaussianParametersArray;
        LinearLayer linearLayer = new LinearLayer();
        this.hidden = new RbfGaussianLayer();
        BiasedLinearLayer biasedLinearLayer = new BiasedLinearLayer();
        linearLayer.setRows(2);
        this.hidden.setRows(2);
        biasedLinearLayer.setRows(1);
        if (!this.randomCenters) {
            rbfGaussianParametersArray = new RbfGaussianParameters[2];
            object2 = new double[]{0.0, 0.0};
            rbfGaussianParametersArray[0] = new RbfGaussianParameters((double[])object2, Math.sqrt(0.5));
            object = new double[]{1.0, 1.0};
            rbfGaussianParametersArray[1] = new RbfGaussianParameters((double[])object, Math.sqrt(0.5));
            this.hidden.setGaussianParameters(rbfGaussianParametersArray);
        }
        rbfGaussianParametersArray = new RbfInputSynapse();
        object2 = new FullSynapse();
        linearLayer.addOutputSynapse((OutputPatternListener)rbfGaussianParametersArray);
        this.hidden.addInputSynapse((InputPatternListener)rbfGaussianParametersArray);
        this.hidden.addOutputSynapse((OutputPatternListener)object2);
        biasedLinearLayer.addInputSynapse((InputPatternListener)object2);
        this.inputSynapse = new MemoryInputSynapse();
        linearLayer.addInputSynapse(this.inputSynapse);
        if (this.randomCenters) {
            this.hidden.useRandomCenter(this.inputSynapse);
        }
        this.desiredOutputSynapse = new MemoryInputSynapse();
        object = new TeachingSynapse();
        ((TeachingSynapse)object).setDesired(this.desiredOutputSynapse);
        this.nnet = new NeuralNet();
        this.nnet.addLayer(linearLayer, 0);
        this.nnet.addLayer(this.hidden, 1);
        this.nnet.addLayer(biasedLinearLayer, 2);
        this.nnet.setTeacher((ComparingElement)object);
        biasedLinearLayer.addOutputSynapse((OutputPatternListener)object);
    }

    public void test() {
        this.outputSynapse = new MemoryOutputSynapse();
        this.nnet.getOutputLayer().addOutputSynapse(this.outputSynapse);
        this.nnet.getMonitor().setTotCicles(1);
        this.nnet.getMonitor().setTrainingPatterns(4);
        this.nnet.getMonitor().setLearning(false);
        this.nnet.removeAllListeners();
        this.nnet.go();
        System.out.println("Outputs");
        System.out.println("-------");
        for (int i = 0; i < 4; ++i) {
            double[] dArray = this.outputSynapse.getNextPattern();
            System.out.println("Output: " + dArray[0]);
        }
        System.out.println("Centers RBF neurons: ");
        RbfGaussianParameters[] rbfGaussianParametersArray = this.hidden.getGaussianParameters();
        for (int i = 0; i < rbfGaussianParametersArray.length; ++i) {
            String string = i + 1 + ": [center: ";
            for (int j = 0; j < rbfGaussianParametersArray[i].getMean().length; ++j) {
                string = string + rbfGaussianParametersArray[i].getMean()[j] + ", ";
            }
            string = string + "Std dev: " + rbfGaussianParametersArray[i].getStdDeviation() + "]";
            System.out.println(string);
        }
    }

    public void cicleTerminated(NeuralNetEvent neuralNetEvent) {
    }

    public void errorChanged(NeuralNetEvent neuralNetEvent) {
        Monitor monitor = (Monitor)neuralNetEvent.getSource();
        if (monitor.getCurrentCicle() % 100 == 0) {
            System.out.println("Epoch: " + (monitor.getTotCicles() - monitor.getCurrentCicle()) + " RMSE:" + monitor.getGlobalError());
        }
    }

    public void netStarted(NeuralNetEvent neuralNetEvent) {
    }

    public void netStopped(NeuralNetEvent neuralNetEvent) {
    }

    public void netStoppedError(NeuralNetEvent neuralNetEvent, String string) {
    }
}

