/*
 * Decompiled with CFR 0.152.
 */
package org.joone.samples.engine.xor;

import java.util.Vector;
import org.joone.engine.FullSynapse;
import org.joone.engine.LinearLayer;
import org.joone.engine.Monitor;
import org.joone.engine.NeuralNetEvent;
import org.joone.engine.NeuralNetListener;
import org.joone.engine.Pattern;
import org.joone.engine.SigmoidLayer;
import org.joone.engine.learning.TeachingSynapse;
import org.joone.io.MemoryInputSynapse;
import org.joone.io.MemoryOutputSynapse;
import org.joone.net.NeuralNet;

public class XOR_using_NeuralNet_RPROP
implements NeuralNetListener {
    private NeuralNet nnet = null;
    private MemoryInputSynapse inputSynapse;
    private MemoryInputSynapse desiredOutputSynapse;
    private MemoryOutputSynapse outputSynapse;
    private double[][] inputArray = new double[][]{{0.0, 0.0}, {0.0, 1.0}, {1.0, 0.0}, {1.0, 1.0}};
    private double[][] desiredOutputArray = new double[][]{{0.0}, {1.0}, {1.0}, {0.0}};

    public static void main(String[] stringArray) {
        XOR_using_NeuralNet_RPROP xOR_using_NeuralNet_RPROP = new XOR_using_NeuralNet_RPROP();
        xOR_using_NeuralNet_RPROP.initNeuralNet();
        xOR_using_NeuralNet_RPROP.train();
    }

    public void train() {
        this.inputSynapse.setInputArray(this.inputArray);
        this.inputSynapse.setAdvancedColumnSelector("1,2");
        this.desiredOutputSynapse.setInputArray(this.desiredOutputArray);
        this.desiredOutputSynapse.setAdvancedColumnSelector("1");
        Monitor monitor = this.nnet.getMonitor();
        monitor.setLearningRate(1.0);
        monitor.setTrainingPatterns(this.inputArray.length);
        monitor.setTotCicles(500);
        monitor.addLearner(0, "org.joone.engine.RpropLearner");
        monitor.setBatchSize(monitor.getTrainingPatterns());
        monitor.setLearningMode(0);
        monitor.setLearning(true);
        this.nnet.addNeuralNetListener(this);
        this.nnet.go();
    }

    protected void initNeuralNet() {
        LinearLayer linearLayer = new LinearLayer();
        SigmoidLayer sigmoidLayer = new SigmoidLayer();
        SigmoidLayer sigmoidLayer2 = new SigmoidLayer();
        linearLayer.setRows(2);
        sigmoidLayer.setRows(3);
        sigmoidLayer2.setRows(1);
        FullSynapse fullSynapse = new FullSynapse();
        FullSynapse fullSynapse2 = new FullSynapse();
        linearLayer.addOutputSynapse(fullSynapse);
        sigmoidLayer.addInputSynapse(fullSynapse);
        sigmoidLayer.addOutputSynapse(fullSynapse2);
        sigmoidLayer2.addInputSynapse(fullSynapse2);
        this.inputSynapse = new MemoryInputSynapse();
        linearLayer.addInputSynapse(this.inputSynapse);
        this.outputSynapse = new MemoryOutputSynapse();
        sigmoidLayer2.addOutputSynapse(this.outputSynapse);
        this.desiredOutputSynapse = new MemoryInputSynapse();
        TeachingSynapse teachingSynapse = new TeachingSynapse();
        teachingSynapse.setDesired(this.desiredOutputSynapse);
        this.nnet = new NeuralNet();
        this.nnet.addLayer(linearLayer, 0);
        this.nnet.addLayer(sigmoidLayer, 1);
        this.nnet.addLayer(sigmoidLayer2, 2);
        this.nnet.setTeacher(teachingSynapse);
        sigmoidLayer2.addOutputSynapse(teachingSynapse);
    }

    public void cicleTerminated(NeuralNetEvent neuralNetEvent) {
    }

    public void errorChanged(NeuralNetEvent neuralNetEvent) {
        Monitor monitor = (Monitor)neuralNetEvent.getSource();
        if (monitor.getCurrentCicle() % 100 == 0) {
            System.out.println("Epoch: " + (monitor.getTotCicles() - monitor.getCurrentCicle()) + " RMSE:" + monitor.getGlobalError());
        }
    }

    public void netStarted(NeuralNetEvent neuralNetEvent) {
    }

    public void netStopped(NeuralNetEvent neuralNetEvent) {
        Monitor monitor = (Monitor)neuralNetEvent.getSource();
        Vector vector = this.outputSynapse.getAllPatterns();
        Pattern pattern = (Pattern)vector.elementAt(vector.size() - 1);
        System.out.println("Output Pattern = " + pattern.getArray()[0] + " Error: " + monitor.getGlobalError());
    }

    public void netStoppedError(NeuralNetEvent neuralNetEvent, String string) {
    }
}

