/*
 * Decompiled with CFR 0.152.
 */
package org.joone.samples.engine.xor;

import org.joone.engine.FullSynapse;
import org.joone.engine.LinearLayer;
import org.joone.engine.Monitor;
import org.joone.engine.NeuralNetEvent;
import org.joone.engine.NeuralNetListener;
import org.joone.engine.SigmoidLayer;
import org.joone.engine.learning.TeachingSynapse;
import org.joone.io.FileOutputSynapse;
import org.joone.io.MemoryInputSynapse;
import org.joone.io.MemoryOutputSynapse;
import org.joone.net.NeuralNet;

public class XOR_using_NeuralNet
implements NeuralNetListener {
    private NeuralNet nnet = null;
    private MemoryInputSynapse inputSynapse;
    private MemoryInputSynapse desiredOutputSynapse;
    private MemoryOutputSynapse outputSynapse;
    LinearLayer input;
    SigmoidLayer hidden;
    SigmoidLayer output;
    boolean singleThreadMode = true;
    private double[][] inputArray = new double[][]{{0.0, 0.0}, {0.0, 1.0}, {1.0, 0.0}, {1.0, 1.0}};
    private double[][] desiredOutputArray = new double[][]{{0.0}, {1.0}, {1.0}, {0.0}};

    public static void main(String[] stringArray) {
        XOR_using_NeuralNet xOR_using_NeuralNet = new XOR_using_NeuralNet();
        xOR_using_NeuralNet.initNeuralNet();
        xOR_using_NeuralNet.train();
        xOR_using_NeuralNet.interrogate();
    }

    public void train() {
        this.inputSynapse.setInputArray(this.inputArray);
        this.inputSynapse.setAdvancedColumnSelector("1,2");
        this.desiredOutputSynapse.setInputArray(this.desiredOutputArray);
        this.desiredOutputSynapse.setAdvancedColumnSelector("1");
        Monitor monitor = this.nnet.getMonitor();
        monitor.setLearningRate(0.8);
        monitor.setMomentum(0.3);
        monitor.setTrainingPatterns(this.inputArray.length);
        monitor.setTotCicles(5000);
        monitor.setLearning(true);
        long l = System.currentTimeMillis();
        this.nnet.getMonitor().setSingleThreadMode(this.singleThreadMode);
        this.nnet.go(true);
        System.out.println("Total time= " + (System.currentTimeMillis() - l) + " ms");
    }

    private void interrogate() {
        this.inputSynapse.setInputArray(this.inputArray);
        this.inputSynapse.setAdvancedColumnSelector("1,2");
        Monitor monitor = this.nnet.getMonitor();
        monitor.setTrainingPatterns(4);
        monitor.setTotCicles(1);
        monitor.setLearning(false);
        FileOutputSynapse fileOutputSynapse = new FileOutputSynapse();
        fileOutputSynapse.setFileName("/tmp/xorOut.txt");
        if (this.nnet != null) {
            this.nnet.addOutputSynapse(fileOutputSynapse);
            System.out.println(this.nnet.check());
            this.nnet.getMonitor().setSingleThreadMode(this.singleThreadMode);
            this.nnet.go();
        }
    }

    protected void initNeuralNet() {
        this.input = new LinearLayer();
        this.hidden = new SigmoidLayer();
        this.output = new SigmoidLayer();
        this.input.setRows(2);
        this.hidden.setRows(3);
        this.output.setRows(1);
        this.input.setLayerName("L.input");
        this.hidden.setLayerName("L.hidden");
        this.output.setLayerName("L.output");
        FullSynapse fullSynapse = new FullSynapse();
        FullSynapse fullSynapse2 = new FullSynapse();
        this.input.addOutputSynapse(fullSynapse);
        this.hidden.addInputSynapse(fullSynapse);
        this.hidden.addOutputSynapse(fullSynapse2);
        this.output.addInputSynapse(fullSynapse2);
        this.inputSynapse = new MemoryInputSynapse();
        this.input.addInputSynapse(this.inputSynapse);
        this.desiredOutputSynapse = new MemoryInputSynapse();
        TeachingSynapse teachingSynapse = new TeachingSynapse();
        teachingSynapse.setDesired(this.desiredOutputSynapse);
        this.nnet = new NeuralNet();
        this.nnet.addLayer(this.input, 0);
        this.nnet.addLayer(this.hidden, 1);
        this.nnet.addLayer(this.output, 2);
        this.nnet.setTeacher(teachingSynapse);
        this.output.addOutputSynapse(teachingSynapse);
        this.nnet.addNeuralNetListener(this);
    }

    public void cicleTerminated(NeuralNetEvent neuralNetEvent) {
    }

    public void errorChanged(NeuralNetEvent neuralNetEvent) {
        Monitor monitor = (Monitor)neuralNetEvent.getSource();
        if (monitor.getCurrentCicle() % 100 == 0) {
            System.out.println("Epoch: " + (monitor.getTotCicles() - monitor.getCurrentCicle()) + " RMSE:" + monitor.getGlobalError());
        }
    }

    public void netStarted(NeuralNetEvent neuralNetEvent) {
        Monitor monitor = (Monitor)neuralNetEvent.getSource();
        System.out.print("Network started for ");
        if (monitor.isLearning()) {
            System.out.println("training.");
        } else {
            System.out.println("interrogation.");
        }
    }

    public void netStopped(NeuralNetEvent neuralNetEvent) {
        Monitor monitor = (Monitor)neuralNetEvent.getSource();
        System.out.println("Network stopped. Last RMSE=" + monitor.getGlobalError());
    }

    public void netStoppedError(NeuralNetEvent neuralNetEvent, String string) {
        System.out.println("Network stopped due the following error: " + string);
    }
}

