/*
 * Decompiled with CFR 0.152.
 */
package org.joone.samples.engine.xor;

import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.util.TreeSet;
import org.joone.engine.Monitor;
import org.joone.engine.NeuralNetEvent;
import org.joone.engine.NeuralNetListener;
import org.joone.net.NetCheck;
import org.joone.net.NeuralNet;

public class XORTrainer
implements NeuralNetListener {
    private static String xorNet = "org/joone/samples/engine/xor/xor.snet";

    public static void main(String[] stringArray) {
        XORTrainer xORTrainer = new XORTrainer();
        xORTrainer.Go(xorNet);
    }

    private void Go(String string) {
        NeuralNet neuralNet = this.restoreNeuralNet(string);
        if (neuralNet != null) {
            neuralNet.getMonitor().addNeuralNetListener(this);
            neuralNet.getMonitor().setLearning(true);
            TreeSet treeSet = neuralNet.check();
            if (treeSet.isEmpty()) {
                neuralNet.go(true);
                System.out.println("Network stopped. Last RMSE=" + neuralNet.getMonitor().getGlobalError());
            } else {
                for (NetCheck netCheck : treeSet) {
                    System.out.println(netCheck.toString());
                }
            }
        }
    }

    private NeuralNet restoreNeuralNet(String string) {
        NeuralNet neuralNet = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            neuralNet = (NeuralNet)objectInputStream.readObject();
        }
        catch (Exception exception) {
            System.out.println("Exception was thrown. Message is : " + exception.getMessage());
        }
        return neuralNet;
    }

    public void cicleTerminated(NeuralNetEvent neuralNetEvent) {
    }

    public void errorChanged(NeuralNetEvent neuralNetEvent) {
        Monitor monitor = (Monitor)neuralNetEvent.getSource();
        long l = monitor.getCurrentCicle();
        if (l % 200L == 0L) {
            System.out.println(l + " epochs remaining - RMSE = " + monitor.getGlobalError());
        }
    }

    public void netStarted(NeuralNetEvent neuralNetEvent) {
        System.out.println("Started...");
    }

    public void netStopped(NeuralNetEvent neuralNetEvent) {
        System.out.println("Stopped...");
    }

    public void netStoppedError(NeuralNetEvent neuralNetEvent, String string) {
        System.out.println("Error: " + string);
        System.exit(1);
    }
}

