/*
 * Decompiled with CFR 0.152.
 */
package org.joone.samples.engine.xor;

import java.io.Serializable;
import java.util.Vector;
import org.joone.engine.FullSynapse;
import org.joone.engine.LinearLayer;
import org.joone.engine.Monitor;
import org.joone.engine.NeuralNetEvent;
import org.joone.engine.NeuralNetListener;
import org.joone.engine.SigmoidLayer;
import org.joone.engine.learning.FahlmanTeacherSynapse;
import org.joone.engine.learning.TeachingSynapse;
import org.joone.io.InputConnector;
import org.joone.net.NeuralNet;
import org.joone.net.NeuralNetValidator;
import org.joone.net.NeuralValidationEvent;
import org.joone.net.NeuralValidationListener;
import org.joone.samples.util.ParityInputSynapse;
import org.joone.util.LearningSwitch;

public class XORFahlman
implements Serializable,
NeuralNetListener,
NeuralValidationListener {
    private NeuralNet nnet = null;
    private Vector validationCycles = new Vector();
    private long mills;

    public static void main(String[] stringArray) {
        XORFahlman xORFahlman = new XORFahlman();
        xORFahlman.Go();
    }

    public void Go() {
        LinearLayer linearLayer = new LinearLayer();
        SigmoidLayer sigmoidLayer = new SigmoidLayer();
        SigmoidLayer sigmoidLayer2 = new SigmoidLayer();
        linearLayer.setLayerName("input");
        sigmoidLayer.setLayerName("hidden");
        sigmoidLayer2.setLayerName("output");
        linearLayer.setRows(2);
        sigmoidLayer.setRows(3);
        sigmoidLayer2.setRows(1);
        FullSynapse fullSynapse = new FullSynapse();
        FullSynapse fullSynapse2 = new FullSynapse();
        fullSynapse.setName("IH");
        fullSynapse2.setName("HO");
        linearLayer.addOutputSynapse(fullSynapse);
        sigmoidLayer.addInputSynapse(fullSynapse);
        sigmoidLayer.addOutputSynapse(fullSynapse2);
        sigmoidLayer2.addInputSynapse(fullSynapse2);
        ParityInputSynapse parityInputSynapse = new ParityInputSynapse();
        parityInputSynapse.setParitySize(2);
        InputConnector inputConnector = new InputConnector();
        inputConnector.setInputSynapse(parityInputSynapse);
        inputConnector.setAdvancedColumnSelector("1-2");
        InputConnector inputConnector2 = new InputConnector();
        inputConnector2.setInputSynapse(parityInputSynapse);
        inputConnector2.setAdvancedColumnSelector("1-2");
        LearningSwitch learningSwitch = new LearningSwitch();
        learningSwitch.addTrainingSet(inputConnector);
        learningSwitch.addValidationSet(inputConnector2);
        linearLayer.addInputSynapse(learningSwitch);
        FahlmanTeacherSynapse fahlmanTeacherSynapse = new FahlmanTeacherSynapse();
        InputConnector inputConnector3 = new InputConnector();
        inputConnector3.setInputSynapse(parityInputSynapse);
        inputConnector3.setAdvancedColumnSelector("3");
        InputConnector inputConnector4 = new InputConnector();
        inputConnector4.setInputSynapse(parityInputSynapse);
        inputConnector4.setAdvancedColumnSelector("3");
        LearningSwitch learningSwitch2 = new LearningSwitch();
        learningSwitch2.addTrainingSet(inputConnector3);
        learningSwitch2.addValidationSet(inputConnector4);
        TeachingSynapse teachingSynapse = new TeachingSynapse(fahlmanTeacherSynapse);
        teachingSynapse.setDesired(learningSwitch2);
        sigmoidLayer2.addOutputSynapse(teachingSynapse);
        this.nnet = new NeuralNet();
        this.nnet.addLayer(linearLayer, 0);
        this.nnet.addLayer(sigmoidLayer, 1);
        this.nnet.addLayer(sigmoidLayer2, 2);
        this.nnet.setTeacher(teachingSynapse);
        this.nnet.getMonitor().setTrainingPatterns(4);
        this.nnet.getMonitor().setValidationPatterns(4);
        this.nnet.getMonitor().setTotCicles(10000);
        this.nnet.getMonitor().setLearning(true);
        this.nnet.getMonitor().setLearningRate(0.8);
        this.nnet.getMonitor().setMomentum(0.3);
        this.mills = System.currentTimeMillis();
        this.nnet.addNeuralNetListener(this);
        this.nnet.go();
    }

    public void netStopped(NeuralNetEvent neuralNetEvent) {
        long l = System.currentTimeMillis() - this.mills;
        System.out.println("Training finished after " + l + " ms");
        System.exit(0);
    }

    public void cicleTerminated(NeuralNetEvent neuralNetEvent) {
        Monitor monitor = (Monitor)neuralNetEvent.getSource();
        long l = monitor.getCurrentCicle();
        if (l % 200L == 0L) {
            this.nnet.getMonitor().setExporting(true);
            NeuralNet neuralNet = this.nnet.cloneNet();
            this.nnet.getMonitor().setExporting(false);
            neuralNet.removeAllListeners();
            neuralNet.getMonitor().setParam("FAHLMAN_CRITERION", Boolean.TRUE);
            NeuralNetValidator neuralNetValidator = new NeuralNetValidator(neuralNet);
            neuralNetValidator.addValidationListener(this);
            this.validationCycles.add(new Integer(this.nnet.getMonitor().getTotCicles() - this.nnet.getMonitor().getCurrentCicle()));
            neuralNetValidator.start();
        }
    }

    public void netStarted(NeuralNetEvent neuralNetEvent) {
        System.out.println("Training...");
    }

    public void errorChanged(NeuralNetEvent neuralNetEvent) {
        Monitor monitor = (Monitor)neuralNetEvent.getSource();
        long l = monitor.getCurrentCicle();
        if (l % 100L == 0L) {
            System.out.println(l + " cycles remaining - Error = " + monitor.getGlobalError());
        }
    }

    public void netStoppedError(NeuralNetEvent neuralNetEvent, String string) {
    }

    public void netValidated(NeuralValidationEvent neuralValidationEvent) {
        Monitor monitor = ((NeuralNet)neuralValidationEvent.getSource()).getMonitor();
        if (monitor.getParam("FAHLMAN_CRITERION") != null && ((Boolean)monitor.getParam("FAHLMAN_CRITERION")).booleanValue() && this.nnet.isRunning()) {
            this.nnet.stop();
            System.out.println("Fahlman criterion fulfilled (at cycle " + (Integer)this.validationCycles.get(0) + ")...");
        }
        this.validationCycles.remove(0);
    }
}

