/*
 * Decompiled with CFR 0.152.
 */
package org.joone.samples.engine.xor;

import java.io.File;
import org.joone.engine.FullSynapse;
import org.joone.engine.LinearLayer;
import org.joone.engine.Monitor;
import org.joone.engine.NeuralNetEvent;
import org.joone.engine.NeuralNetListener;
import org.joone.engine.SigmoidLayer;
import org.joone.engine.learning.TeachingSynapse;
import org.joone.io.FileInputSynapse;
import org.joone.io.FileOutputSynapse;
import org.joone.net.NeuralNet;

public class XOR
implements NeuralNetListener {
    private static String inputData = "org/joone/samples/engine/xor/xor.txt";
    private static String outputFile = "/tmp/xorout.txt";

    public static void main(String[] stringArray) {
        XOR xOR = new XOR();
        xOR.Go(inputData, outputFile);
    }

    public void Go(String string, String string2) {
        LinearLayer linearLayer = new LinearLayer();
        SigmoidLayer sigmoidLayer = new SigmoidLayer();
        SigmoidLayer sigmoidLayer2 = new SigmoidLayer();
        linearLayer.setLayerName("input");
        sigmoidLayer.setLayerName("hidden");
        sigmoidLayer2.setLayerName("output");
        linearLayer.setRows(2);
        sigmoidLayer.setRows(3);
        sigmoidLayer2.setRows(1);
        FullSynapse fullSynapse = new FullSynapse();
        FullSynapse fullSynapse2 = new FullSynapse();
        fullSynapse.setName("IH");
        fullSynapse2.setName("HO");
        linearLayer.addOutputSynapse(fullSynapse);
        sigmoidLayer.addInputSynapse(fullSynapse);
        sigmoidLayer.addOutputSynapse(fullSynapse2);
        sigmoidLayer2.addInputSynapse(fullSynapse2);
        FileInputSynapse fileInputSynapse = new FileInputSynapse();
        fileInputSynapse.setAdvancedColumnSelector("1,2");
        fileInputSynapse.setInputFile(new File(string));
        linearLayer.addInputSynapse(fileInputSynapse);
        TeachingSynapse teachingSynapse = new TeachingSynapse();
        FileInputSynapse fileInputSynapse2 = new FileInputSynapse();
        fileInputSynapse2.setInputFile(new File(string));
        fileInputSynapse2.setAdvancedColumnSelector("3");
        teachingSynapse.setDesired(fileInputSynapse2);
        FileOutputSynapse fileOutputSynapse = new FileOutputSynapse();
        fileOutputSynapse.setFileName(string2);
        teachingSynapse.addResultSynapse(fileOutputSynapse);
        sigmoidLayer2.addOutputSynapse(teachingSynapse);
        NeuralNet neuralNet = new NeuralNet();
        neuralNet.addLayer(linearLayer, 0);
        neuralNet.addLayer(sigmoidLayer, 1);
        neuralNet.addLayer(sigmoidLayer2, 2);
        neuralNet.setTeacher(teachingSynapse);
        Monitor monitor = neuralNet.getMonitor();
        monitor.setLearningRate(0.8);
        monitor.setMomentum(0.3);
        monitor.addNeuralNetListener(this);
        monitor.setTrainingPatterns(4);
        monitor.setTotCicles(2000);
        monitor.setLearning(true);
        neuralNet.go();
    }

    public void netStopped(NeuralNetEvent neuralNetEvent) {
        System.out.println("Training finished");
    }

    public void cicleTerminated(NeuralNetEvent neuralNetEvent) {
    }

    public void netStarted(NeuralNetEvent neuralNetEvent) {
        System.out.println("Training...");
    }

    public void errorChanged(NeuralNetEvent neuralNetEvent) {
        Monitor monitor = (Monitor)neuralNetEvent.getSource();
        if (monitor.getCurrentCicle() % 200 == 0) {
            System.out.println(monitor.getCurrentCicle() + " epochs remaining - RMSE = " + monitor.getGlobalError());
        }
    }

    public void netStoppedError(NeuralNetEvent neuralNetEvent, String string) {
    }
}

