/*
 * Decompiled with CFR 0.152.
 */
package org.joone.samples.engine.xor;

import java.io.FileInputStream;
import java.io.ObjectInputStream;
import org.joone.engine.DirectSynapse;
import org.joone.engine.Layer;
import org.joone.engine.Pattern;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;
import org.joone.net.NeuralNet;

public class ImmediateEmbeddedXOR {
    private static final ILogger log = LoggerFactory.getLogger(ImmediateEmbeddedXOR.class);
    private double[][] inputArray = new double[][]{{0.0, 0.0}, {0.0, 1.0}, {1.0, 0.0}, {1.0, 1.0}};
    private static String xorNet = "org/joone/samples/engine/xor/xor.snet";

    public static void main(String[] stringArray) {
        ImmediateEmbeddedXOR immediateEmbeddedXOR = new ImmediateEmbeddedXOR();
        immediateEmbeddedXOR.Go(xorNet);
    }

    private void Go(String string) {
        NeuralNet neuralNet = this.restoreNeuralNet(string);
        if (neuralNet != null) {
            Layer layer = neuralNet.getInputLayer();
            layer.removeAllInputs();
            Layer layer2 = neuralNet.getOutputLayer();
            layer2.removeAllOutputs();
            DirectSynapse directSynapse = new DirectSynapse();
            layer2.addOutputSynapse(directSynapse);
            neuralNet.getMonitor().setLearning(false);
            for (int i = 0; i < 100; ++i) {
                log.debug("Launch #" + i);
                for (int j = 0; j < 4; ++j) {
                    Pattern pattern = new Pattern(this.inputArray[j]);
                    pattern.setCount(j + 1);
                    neuralNet.singleStepForward(pattern);
                    Pattern pattern2 = directSynapse.fwdGet();
                    log.debug("Output Pattern #" + (j + 1) + " = " + pattern2.getArray()[0]);
                }
            }
            log.debug("Finished");
        }
    }

    private NeuralNet restoreNeuralNet(String string) {
        NeuralNet neuralNet = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            neuralNet = (NeuralNet)objectInputStream.readObject();
        }
        catch (Exception exception) {
            log.warn("Exception thrown while restoring the Neural Net. Message is : " + exception.getMessage(), exception);
        }
        return neuralNet;
    }
}

