/*
 * Decompiled with CFR 0.152.
 */
package org.joone.samples.engine.validation;

import java.io.File;
import org.joone.engine.FullSynapse;
import org.joone.engine.Layer;
import org.joone.engine.LinearLayer;
import org.joone.engine.Monitor;
import org.joone.engine.NeuralNetEvent;
import org.joone.engine.NeuralNetListener;
import org.joone.engine.SigmoidLayer;
import org.joone.engine.Synapse;
import org.joone.engine.learning.TeachingSynapse;
import org.joone.io.FileInputSynapse;
import org.joone.io.StreamInputSynapse;
import org.joone.net.NeuralNet;
import org.joone.net.NeuralNetValidator;
import org.joone.net.NeuralValidationEvent;
import org.joone.net.NeuralValidationListener;
import org.joone.util.LearningSwitch;
import org.joone.util.NormalizerPlugIn;

public class SimpleValidationSample
implements NeuralNetListener,
NeuralValidationListener {
    NeuralNet net;
    long startms;
    private static String filePath = "org/joone/samples/engine/validation";

    public static void main(String[] stringArray) {
        SimpleValidationSample simpleValidationSample = new SimpleValidationSample();
        simpleValidationSample.initialize(filePath);
        simpleValidationSample.start();
    }

    private void initialize(String string) {
        LinearLayer linearLayer = new LinearLayer();
        SigmoidLayer sigmoidLayer = new SigmoidLayer();
        SigmoidLayer sigmoidLayer2 = new SigmoidLayer();
        linearLayer.setRows(13);
        sigmoidLayer.setRows(4);
        sigmoidLayer2.setRows(1);
        FullSynapse fullSynapse = new FullSynapse();
        FullSynapse fullSynapse2 = new FullSynapse();
        this.connect(linearLayer, fullSynapse, sigmoidLayer);
        this.connect(sigmoidLayer, fullSynapse2, sigmoidLayer2);
        FileInputSynapse fileInputSynapse = this.createInput(string + "/wine.txt", 1, 2, 14);
        FileInputSynapse fileInputSynapse2 = this.createInput(string + "/wine.txt", 131, 2, 14);
        FileInputSynapse fileInputSynapse3 = this.createInput(string + "/wine.txt", 1, 1, 1);
        FileInputSynapse fileInputSynapse4 = this.createInput(string + "/wine.txt", 131, 1, 1);
        LearningSwitch learningSwitch = this.createSwitch(fileInputSynapse, fileInputSynapse2);
        linearLayer.addInputSynapse(learningSwitch);
        LearningSwitch learningSwitch2 = this.createSwitch(fileInputSynapse3, fileInputSynapse4);
        TeachingSynapse teachingSynapse = new TeachingSynapse();
        teachingSynapse.setDesired(learningSwitch2);
        sigmoidLayer2.addOutputSynapse(teachingSynapse);
        this.net = new NeuralNet();
        this.net.addLayer(linearLayer, 0);
        this.net.addLayer(sigmoidLayer, 1);
        this.net.addLayer(sigmoidLayer2, 2);
        this.net.setTeacher(teachingSynapse);
        Monitor monitor = this.net.getMonitor();
        monitor.setLearningRate(0.4);
        monitor.setMomentum(0.5);
        monitor.setTrainingPatterns(130);
        monitor.setValidationPatterns(48);
        monitor.setTotCicles(1000);
        monitor.setLearning(true);
    }

    private FileInputSynapse createInput(String string, int n, int n2, int n3) {
        FileInputSynapse fileInputSynapse = new FileInputSynapse();
        fileInputSynapse.setInputFile(new File(string));
        fileInputSynapse.setFirstRow(n);
        if (n2 != n3) {
            fileInputSynapse.setAdvancedColumnSelector(n2 + "-" + n3);
        } else {
            fileInputSynapse.setAdvancedColumnSelector(Integer.toString(n2));
        }
        NormalizerPlugIn normalizerPlugIn = new NormalizerPlugIn();
        if (n2 != n3) {
            normalizerPlugIn.setAdvancedSerieSelector("1-" + Integer.toString(n3 - n2 + 1));
        } else {
            normalizerPlugIn.setAdvancedSerieSelector("1");
        }
        normalizerPlugIn.setMin(0.1);
        normalizerPlugIn.setMax(0.9);
        fileInputSynapse.addPlugIn(normalizerPlugIn);
        return fileInputSynapse;
    }

    private void connect(Layer layer, Synapse synapse, Layer layer2) {
        layer.addOutputSynapse(synapse);
        layer2.addInputSynapse(synapse);
    }

    private LearningSwitch createSwitch(StreamInputSynapse streamInputSynapse, StreamInputSynapse streamInputSynapse2) {
        LearningSwitch learningSwitch = new LearningSwitch();
        learningSwitch.addTrainingSet(streamInputSynapse);
        learningSwitch.addValidationSet(streamInputSynapse2);
        return learningSwitch;
    }

    private void start() {
        this.net.getMonitor().addNeuralNetListener(this);
        this.startms = System.currentTimeMillis();
        this.net.go();
    }

    public void netValidated(NeuralValidationEvent neuralValidationEvent) {
        NeuralNet neuralNet = (NeuralNet)neuralValidationEvent.getSource();
        System.out.println("    Validation Error: " + neuralNet.getMonitor().getGlobalError());
    }

    public void cicleTerminated(NeuralNetEvent neuralNetEvent) {
        int n = this.net.getMonitor().getTotCicles() - this.net.getMonitor().getCurrentCicle() + 1;
        if (n % 200 == 0) {
            System.out.println("Cycle #" + n);
            System.out.println("    Training Error:   " + this.net.getMonitor().getGlobalError());
            this.net.getMonitor().setExporting(true);
            NeuralNet neuralNet = this.net.cloneNet();
            this.net.getMonitor().setExporting(false);
            neuralNet.removeAllListeners();
            NeuralNetValidator neuralNetValidator = new NeuralNetValidator(neuralNet);
            neuralNetValidator.addValidationListener(this);
            neuralNetValidator.start();
        }
    }

    public void errorChanged(NeuralNetEvent neuralNetEvent) {
    }

    public void netStarted(NeuralNetEvent neuralNetEvent) {
    }

    public void netStopped(NeuralNetEvent neuralNetEvent) {
        System.out.println("Stopped after " + (System.currentTimeMillis() - this.startms) + " ms");
    }

    public void netStoppedError(NeuralNetEvent neuralNetEvent, String string) {
    }
}

