/*
 * Decompiled with CFR 0.152.
 */
package org.joone.samples.engine.multipleInputs;

import java.io.File;
import org.joone.engine.FullSynapse;
import org.joone.engine.LinearLayer;
import org.joone.engine.Monitor;
import org.joone.engine.NeuralNetEvent;
import org.joone.engine.NeuralNetListener;
import org.joone.engine.SigmoidLayer;
import org.joone.engine.learning.TeachingSynapse;
import org.joone.io.FileInputSynapse;
import org.joone.io.FileOutputSynapse;
import org.joone.io.InputSwitchSynapse;
import org.joone.io.MultipleInputSynapse;
import org.joone.net.NeuralNet;

public class XOR_multipleInputs
implements NeuralNetListener {
    private NeuralNet nnet = null;
    private FileInputSynapse inputSynapse1;
    private FileInputSynapse inputSynapse2;
    private FileInputSynapse inputSynapse3;
    private FileInputSynapse desiredSynapse1;
    private FileInputSynapse desiredSynapse2;
    private FileInputSynapse desiredSynapse3;
    private InputSwitchSynapse inputSw;
    private InputSwitchSynapse desiredSw;
    private static String inputFileName = "org/joone/samples/engine/multipleInputs/xor.txt";

    public static void main(String[] stringArray) {
        XOR_multipleInputs xOR_multipleInputs = new XOR_multipleInputs();
        xOR_multipleInputs.initNeuralNet();
        xOR_multipleInputs.train();
        xOR_multipleInputs.interrogate();
    }

    public void train() {
        Monitor monitor = this.nnet.getMonitor();
        monitor.setLearningRate(0.8);
        monitor.setMomentum(0.3);
        monitor.setTrainingPatterns(9);
        monitor.setTotCicles(2000);
        monitor.setLearning(true);
        this.nnet.addNeuralNetListener(this);
        this.nnet.go(true);
        System.out.println("Network stopped. Last RMSE=" + this.nnet.getMonitor().getGlobalError());
    }

    private void interrogate() {
        Monitor monitor = this.nnet.getMonitor();
        monitor.setTotCicles(1);
        monitor.setLearning(false);
        FileOutputSynapse fileOutputSynapse = new FileOutputSynapse();
        fileOutputSynapse.setFileName("/tmp/xorOut.txt");
        if (this.nnet != null) {
            this.nnet.addOutputSynapse(fileOutputSynapse);
            System.out.println(this.nnet.check());
            this.nnet.go(true);
        }
    }

    protected void initNeuralNet() {
        LinearLayer linearLayer = new LinearLayer();
        SigmoidLayer sigmoidLayer = new SigmoidLayer();
        SigmoidLayer sigmoidLayer2 = new SigmoidLayer();
        linearLayer.setRows(2);
        sigmoidLayer.setRows(3);
        sigmoidLayer2.setRows(1);
        linearLayer.setLayerName("inputLayer");
        sigmoidLayer.setLayerName("hiddenLayer");
        sigmoidLayer2.setLayerName("outputLayer");
        FullSynapse fullSynapse = new FullSynapse();
        FullSynapse fullSynapse2 = new FullSynapse();
        linearLayer.addOutputSynapse(fullSynapse);
        sigmoidLayer.addInputSynapse(fullSynapse);
        sigmoidLayer.addOutputSynapse(fullSynapse2);
        sigmoidLayer2.addInputSynapse(fullSynapse2);
        this.inputSynapse1 = new FileInputSynapse();
        this.inputSynapse2 = new FileInputSynapse();
        this.inputSynapse3 = new FileInputSynapse();
        this.inputSynapse1.setInputFile(new File(inputFileName));
        this.inputSynapse1.setName("input1");
        this.inputSynapse1.setAdvancedColumnSelector("1-2");
        this.inputSynapse1.setFirstRow(1);
        this.inputSynapse1.setLastRow(4);
        this.inputSynapse2.setInputFile(new File(inputFileName));
        this.inputSynapse2.setName("input2");
        this.inputSynapse2.setAdvancedColumnSelector("1-2");
        this.inputSynapse2.setFirstRow(2);
        this.inputSynapse2.setLastRow(4);
        this.inputSynapse3.setInputFile(new File(inputFileName));
        this.inputSynapse3.setName("input3");
        this.inputSynapse3.setAdvancedColumnSelector("1-2");
        this.inputSynapse3.setFirstRow(3);
        this.inputSynapse3.setLastRow(4);
        this.inputSw = new MultipleInputSynapse();
        this.inputSw.addInputSynapse(this.inputSynapse1);
        this.inputSw.addInputSynapse(this.inputSynapse2);
        this.inputSw.addInputSynapse(this.inputSynapse3);
        linearLayer.addInputSynapse(this.inputSw);
        this.desiredSynapse1 = new FileInputSynapse();
        this.desiredSynapse2 = new FileInputSynapse();
        this.desiredSynapse3 = new FileInputSynapse();
        this.desiredSynapse1.setInputFile(new File(inputFileName));
        this.desiredSynapse1.setName("desired1");
        this.desiredSynapse1.setAdvancedColumnSelector("3");
        this.desiredSynapse1.setFirstRow(1);
        this.desiredSynapse1.setLastRow(4);
        this.desiredSynapse2.setInputFile(new File(inputFileName));
        this.desiredSynapse2.setName("desired2");
        this.desiredSynapse2.setAdvancedColumnSelector("3");
        this.desiredSynapse2.setFirstRow(2);
        this.desiredSynapse2.setLastRow(4);
        this.desiredSynapse3.setInputFile(new File(inputFileName));
        this.desiredSynapse3.setName("desired3");
        this.desiredSynapse3.setAdvancedColumnSelector("3");
        this.desiredSynapse3.setFirstRow(3);
        this.desiredSynapse3.setLastRow(4);
        this.desiredSw = new MultipleInputSynapse();
        this.desiredSw.addInputSynapse(this.desiredSynapse1);
        this.desiredSw.addInputSynapse(this.desiredSynapse2);
        this.desiredSw.addInputSynapse(this.desiredSynapse3);
        TeachingSynapse teachingSynapse = new TeachingSynapse();
        teachingSynapse.setDesired(this.desiredSw);
        this.nnet = new NeuralNet();
        this.nnet.addLayer(linearLayer, 0);
        this.nnet.addLayer(sigmoidLayer, 1);
        this.nnet.addLayer(sigmoidLayer2, 2);
        this.nnet.setTeacher(teachingSynapse);
        sigmoidLayer2.addOutputSynapse(teachingSynapse);
    }

    public void cicleTerminated(NeuralNetEvent neuralNetEvent) {
    }

    public void errorChanged(NeuralNetEvent neuralNetEvent) {
        Monitor monitor = (Monitor)neuralNetEvent.getSource();
        if (monitor.getCurrentCicle() % 100 == 0) {
            System.out.println("Epoch: " + (monitor.getTotCicles() - monitor.getCurrentCicle()) + " RMSE:" + monitor.getGlobalError());
        }
    }

    public void netStarted(NeuralNetEvent neuralNetEvent) {
        Monitor monitor = (Monitor)neuralNetEvent.getSource();
        if (monitor.isLearning()) {
            System.out.println("Training...");
        }
    }

    public void netStopped(NeuralNetEvent neuralNetEvent) {
        System.out.println("Stopped");
    }

    public void netStoppedError(NeuralNetEvent neuralNetEvent, String string) {
    }
}

