/*
 * Decompiled with CFR 0.152.
 */
package org.joone.samples.editor.som;

import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;

public class CoordGenerator
extends JFrame {
    private Vector coords;
    private boolean alone;
    String fileName = "/tmp/coords.txt";
    private JMenuItem aboutMenuItem;
    private JMenuItem exitMenuItem;
    private JMenu fileMenu;
    private JMenu helpMenu;
    private JSeparator jSeparator1;
    private JMenuBar menuBar;
    private JMenuItem newMenuItem;
    private JMenuItem saveMenuItem;

    public CoordGenerator() {
        this(false);
    }

    public CoordGenerator(boolean bl) {
        this.alone = bl;
        this.initComponents();
        this.coords = new Vector();
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                System.out.println("x=" + mouseEvent.getX() + " y=" + mouseEvent.getY());
                int[] nArray = new int[]{mouseEvent.getX(), mouseEvent.getY()};
                CoordGenerator.this.coords.addElement(nArray);
                CoordGenerator.this.repaint();
            }
        });
        this.setSize(640, 480);
    }

    private void initComponents() {
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.newMenuItem = new JMenuItem();
        this.saveMenuItem = new JMenuItem();
        this.jSeparator1 = new JSeparator();
        this.exitMenuItem = new JMenuItem();
        this.helpMenu = new JMenu();
        this.aboutMenuItem = new JMenuItem();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                CoordGenerator.this.exitForm(windowEvent);
            }
        });
        this.fileMenu.setText("File");
        this.fileMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CoordGenerator.this.fileMenuActionPerformed(actionEvent);
            }
        });
        this.newMenuItem.setText("New");
        this.newMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CoordGenerator.this.newMenuItemActionPerformed(actionEvent);
            }
        });
        this.fileMenu.add(this.newMenuItem);
        this.saveMenuItem.setText("Save");
        this.saveMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CoordGenerator.this.saveMenuItemActionPerformed(actionEvent);
            }
        });
        this.fileMenu.add(this.saveMenuItem);
        this.fileMenu.add(this.jSeparator1);
        this.exitMenuItem.setText("Exit");
        this.exitMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CoordGenerator.this.exitMenuItemActionPerformed(actionEvent);
            }
        });
        this.fileMenu.add(this.exitMenuItem);
        this.menuBar.add(this.fileMenu);
        this.helpMenu.setText("Help");
        this.aboutMenuItem.setText("About");
        this.aboutMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CoordGenerator.this.aboutMenuItemActionPerformed(actionEvent);
            }
        });
        this.helpMenu.add(this.aboutMenuItem);
        this.menuBar.add(this.helpMenu);
        this.setJMenuBar(this.menuBar);
        this.pack();
    }

    private void aboutMenuItemActionPerformed(ActionEvent actionEvent) {
        String string = new String("This application allows the user to plot a figure for recognition by a Joone neural network.");
        String string2 = new String("It is intended to test a SOM or Kohonen Network by providing an image recognition example.");
        String string3 = new String("Draw a whatever figure clicking on the drawing area, and then save the figure into a file.");
        String string4 = new String("The saved file must be used as input of the figureRecognition.ser neural network.");
        JOptionPane.showMessageDialog(this, string + "\n" + string2 + "\n" + string3 + "\n" + string4);
    }

    private void saveMenuItemActionPerformed(ActionEvent actionEvent) {
        try {
            FileWriter fileWriter = new FileWriter(this.fileName);
            for (int i = 0; i < this.coords.size(); ++i) {
                int[] nArray = (int[])this.coords.elementAt(i);
                fileWriter.write(Integer.toString(nArray[0]) + ";");
                fileWriter.write(Integer.toString(nArray[1]) + "\n");
            }
            fileWriter.close();
            System.out.println("Written " + this.coords.size() + " coords");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void newMenuItemActionPerformed(ActionEvent actionEvent) {
        this.coords = new Vector();
        this.repaint();
    }

    private void fileMenuActionPerformed(ActionEvent actionEvent) {
    }

    private void exitMenuItemActionPerformed(ActionEvent actionEvent) {
        this.exitTester();
    }

    private void exitForm(WindowEvent windowEvent) {
        this.exitTester();
    }

    private void exitTester() {
        if (this.alone) {
            System.exit(0);
        } else {
            this.dispose();
        }
    }

    public static void main(String[] stringArray) {
        new CoordGenerator(true).show();
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        for (int i = 0; i < this.coords.size(); ++i) {
            int[] nArray = (int[])this.coords.elementAt(i);
            graphics.fillOval(nArray[0], nArray[1], 3, 3);
        }
    }
}

