/*
 * Decompiled with CFR 0.152.
 */
package org.joone.net;

import java.util.Vector;
import org.joone.engine.NeuralNetEvent;
import org.joone.engine.NeuralNetListener;
import org.joone.net.NeuralNet;
import org.joone.net.NeuralValidationEvent;
import org.joone.net.NeuralValidationListener;

public class NeuralNetValidator
implements Runnable,
NeuralNetListener {
    private final Vector listeners = new Vector();
    private final NeuralNet nnet;
    private Thread myThread = null;
    private int currentCycle;
    private int totCycles;
    private boolean useTrainingData = false;

    public NeuralNetValidator(NeuralNet neuralNet) {
        this.nnet = neuralNet;
    }

    public synchronized void addValidationListener(NeuralValidationListener neuralValidationListener) {
        if (!this.listeners.contains(neuralValidationListener)) {
            this.listeners.addElement(neuralValidationListener);
        }
    }

    protected void validate() {
        this.totCycles = this.nnet.getMonitor().getTotCicles();
        this.currentCycle = this.nnet.getMonitor().getCurrentCicle();
        this.nnet.getMonitor().addNeuralNetListener(this);
        this.nnet.getMonitor().setLearning(false);
        this.nnet.getMonitor().setValidation(true);
        this.nnet.getMonitor().setTrainingDataForValidation(this.useTrainingData);
        this.nnet.getMonitor().setTotCicles(1);
        this.nnet.go();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireNetValidated() {
        Object[] objectArray;
        double d = this.nnet.getMonitor().getGlobalError();
        this.nnet.getDescriptor().setValidationError(d);
        NeuralNetValidator neuralNetValidator = this;
        synchronized (neuralNetValidator) {
            objectArray = this.listeners.toArray();
        }
        for (int i = 0; i < objectArray.length; ++i) {
            NeuralValidationListener neuralValidationListener = (NeuralValidationListener)objectArray[i];
            neuralValidationListener.netValidated(new NeuralValidationEvent(this.nnet));
        }
    }

    public void useTrainingData(boolean bl) {
        this.useTrainingData = bl;
    }

    public void start() {
        if (this.myThread == null) {
            this.myThread = new Thread((Runnable)this, "Validator");
            this.myThread.start();
        }
    }

    public void run() {
        this.validate();
        this.myThread = null;
    }

    public void netStopped(NeuralNetEvent neuralNetEvent) {
        this.fireNetValidated();
    }

    public void cicleTerminated(NeuralNetEvent neuralNetEvent) {
    }

    public void netStarted(NeuralNetEvent neuralNetEvent) {
    }

    public void errorChanged(NeuralNetEvent neuralNetEvent) {
    }

    public void netStoppedError(NeuralNetEvent neuralNetEvent, String string) {
    }

    public NeuralNet getNeuralNet() {
        return this.nnet;
    }
}

