/*
 * Decompiled with CFR 0.152.
 */
package org.joone.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.TreeSet;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.joone.engine.NetErrorManager;
import org.joone.engine.Pattern;
import org.joone.io.StreamOutputSynapse;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;
import org.joone.net.NetCheck;

public class XLSOutputSynapse
extends StreamOutputSynapse {
    private static final ILogger log = LoggerFactory.getLogger(XLSOutputSynapse.class);
    static final long serialVersionUID = -9167076940131905606L;
    private String FileName = "";
    private transient FileOutputStream o_stream;
    private transient FileInputStream i_stream;
    private transient HSSFSheet o_sheet;
    private int o_sheet_index = -1;
    private int row_no = 0;
    private int startCol = 0;
    private int startRow = 0;
    private transient HSSFWorkbook workbook;
    private String o_sheet_name = "j_output";

    public synchronized void flush() {
        try {
            this.workbook.write((OutputStream)this.o_stream);
        }
        catch (IOException iOException) {
            this.logWarn(iOException);
        }
    }

    public synchronized void write(Pattern pattern) {
        if (this.workbook == null || pattern.getCount() == 1) {
            try {
                this.initOutputStream();
            }
            catch (IOException iOException) {
                this.logWarn(iOException);
            }
        }
        if (pattern.isMarkedAsStoppingPattern()) {
            try {
                this.o_stream = new FileOutputStream(this.FileName);
                this.workbook.write((OutputStream)this.o_stream);
                this.o_stream.close();
                this.row_no = this.startRow;
                this.workbook = null;
            }
            catch (IOException iOException) {
                this.logWarn(iOException);
            }
        } else {
            double[] dArray = pattern.getArray();
            HSSFRow hSSFRow = this.o_sheet.getRow(this.row_no) == null ? this.o_sheet.createRow((short)this.row_no) : this.o_sheet.getRow(this.row_no);
            for (int i = 0; i < dArray.length; ++i) {
                if (hSSFRow.getCell((short)(i + this.startCol)) != null) {
                    hSSFRow.removeCell(hSSFRow.getCell((short)(i + this.startCol)));
                }
                HSSFCell hSSFCell = hSSFRow.createCell((short)(i + this.startCol), 0);
                hSSFCell.setCellValue(dArray[i]);
            }
            ++this.row_no;
        }
    }

    public String getFileName() {
        return this.FileName;
    }

    public void setFileName(String string) {
        this.FileName = string;
    }

    private void initOutputStream() throws IOException {
        if (new File(this.FileName).exists()) {
            this.i_stream = new FileInputStream(this.FileName);
            POIFSFileSystem pOIFSFileSystem = new POIFSFileSystem((InputStream)this.i_stream);
            this.workbook = new HSSFWorkbook(pOIFSFileSystem);
            this.i_stream.close();
        } else {
            this.o_stream = new FileOutputStream(this.FileName);
            this.workbook = new HSSFWorkbook();
            this.workbook.write((OutputStream)this.o_stream);
            this.o_stream.close();
        }
        this.o_sheet_index = this.workbook.getSheetIndex(this.o_sheet_name);
        this.o_sheet = this.o_sheet_index != -1 ? this.workbook.getSheetAt(this.o_sheet_index) : this.workbook.createSheet(this.o_sheet_name);
        this.row_no = this.startRow;
    }

    public void setSheetName(String string) {
        this.o_sheet_name = string;
    }

    public synchronized String[] getAvailableSheetList() {
        int n = this.workbook.getNumberOfSheets();
        String[] stringArray = new String[n];
        for (int i = 0; i > n; ++i) {
            stringArray[i] = this.workbook.getSheetName(i);
        }
        return stringArray;
    }

    public String getSheetName() {
        return this.o_sheet_name;
    }

    public TreeSet check() {
        TreeSet treeSet = super.check();
        if (this.FileName == null || this.FileName.trim().equals("")) {
            treeSet.add(new NetCheck(0, "File Name not set.", this));
        }
        return treeSet;
    }

    public int getStartRow(int n) {
        return n;
    }

    public int getStartCol(int n) {
        return n;
    }

    public void setStartRow(int n) {
        this.startRow = n;
    }

    public void setStartCol(int n) {
        this.startCol = n;
    }

    private void logWarn(IOException iOException) {
        String string = "IOException in " + this.getName() + ". Message is : ";
        log.warn(string + iOException);
        if (this.getMonitor() != null) {
            new NetErrorManager(this.getMonitor(), string + iOException.getMessage());
        }
    }
}

