/*
 * Decompiled with CFR 0.152.
 */
package org.joone.io;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.joone.io.PatternTokenizer;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;

public class XLSInputTokenizer
implements PatternTokenizer {
    private static final ILogger log = LoggerFactory.getLogger(XLSInputTokenizer.class);
    private int numTokens = 0;
    private char m_decimalPoint = (char)46;
    private double[] tokensArray;
    private int row_no = 0;
    private int mark_row = 0;
    private final HSSFSheet sheet;

    public XLSInputTokenizer(HSSFSheet hSSFSheet) throws IOException {
        this.sheet = hSSFSheet;
    }

    public int getLineno() {
        return this.row_no;
    }

    public int getNumTokens() throws IOException {
        return this.numTokens;
    }

    public double getTokenAt(int n) throws IOException {
        if (this.tokensArray == null && !this.nextLine()) {
            return 0.0;
        }
        if (this.tokensArray.length <= n) {
            return 0.0;
        }
        return this.tokensArray[n];
    }

    public double[] getTokensArray() {
        return this.tokensArray;
    }

    public void mark() throws IOException {
        this.mark_row = this.row_no;
    }

    public boolean nextLine() throws IOException {
        int n = this.sheet.getLastRowNum();
        if (this.row_no <= n) {
            HSSFRow hSSFRow = this.sheet.getRow(this.row_no);
            if (hSSFRow == null) {
                this.numTokens = 0;
                this.tokensArray = new double[this.numTokens];
            } else {
                Object object;
                short s = 0;
                Hashtable<Integer, Double> hashtable = new Hashtable<Integer, Double>();
                Iterator iterator = hSSFRow.cellIterator();
                while (iterator.hasNext()) {
                    double d = 0.0;
                    object = (HSSFCell)iterator.next();
                    short s2 = object.getCellNum();
                    if (s2 > s) {
                        s = s2;
                    }
                    switch (object.getCellType()) {
                        case 1: {
                            String string = object.getStringCellValue();
                            try {
                                d = Double.valueOf(string);
                            }
                            catch (NumberFormatException numberFormatException) {
                                log.warn("Warning: Not numeric cell at (" + this.row_no + "," + s2 + "): <" + string + "> - Skipping");
                                d = 0.0;
                            }
                            break;
                        }
                        case 0: {
                            d = object.getNumericCellValue();
                        }
                    }
                    hashtable.put(new Integer(s2), new Double(d));
                }
                this.tokensArray = new double[s + 1];
                Enumeration enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    Integer n2 = (Integer)enumeration.nextElement();
                    object = (Double)hashtable.get(n2);
                    this.tokensArray[n2.intValue()] = (Double)object;
                }
            }
            ++this.row_no;
            return true;
        }
        return false;
    }

    public void resetInput() throws IOException {
        this.row_no = this.mark_row;
    }

    public void setDecimalPoint(char c) {
        this.m_decimalPoint = c;
    }

    public char getDecimalPoint() {
        return this.m_decimalPoint;
    }
}

