/*
 * Decompiled with CFR 0.152.
 */
package org.joone.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import org.joone.engine.NetErrorManager;
import org.joone.exception.JooneRuntimeException;
import org.joone.io.StreamInputSynapse;
import org.joone.io.StreamInputTokenizer;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;

public class URLInputSynapse
extends StreamInputSynapse {
    private static final ILogger log = LoggerFactory.getLogger(URLInputSynapse.class);
    private String URL = "http://";
    private URL cURL;
    private static final long serialVersionUID = -1871585397469526608L;

    public String getURL() {
        return this.URL;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        super.readObjectBase(objectInputStream);
        if (objectInputStream.getClass().getName().indexOf("xstream") == -1) {
            this.URL = (String)objectInputStream.readObject();
        }
        if (!this.isBuffered() || this.getInputVector().size() == 0) {
            this.setURL(this.URL);
        }
    }

    public void setURL(String string) {
        if (!this.URL.equals(string)) {
            this.resetInput();
            this.setTokens(null);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        super.writeObjectBase(objectOutputStream);
        if (objectOutputStream.getClass().getName().indexOf("xstream") == -1) {
            objectOutputStream.writeObject(this.URL);
        }
    }

    protected void initInputStream() throws JooneRuntimeException {
        if (this.URL != null && !"".equals(this.URL.trim())) {
            try {
                this.cURL = new URL(this.URL);
                InputStream inputStream = this.cURL.openStream();
                StreamInputTokenizer streamInputTokenizer = this.getMaxBufSize() > 0 ? new StreamInputTokenizer(new InputStreamReader(inputStream), this.getMaxBufSize()) : new StreamInputTokenizer(new InputStreamReader(inputStream));
                super.setTokens(streamInputTokenizer);
            }
            catch (IOException iOException) {
                log.warn("Could not extract data from the URL '" + this.URL + "' Message is : " + iOException.getMessage());
                if (this.getMonitor() != null) {
                    new NetErrorManager(this.getMonitor(), "Could not extract data from the URL '" + this.URL + "' Message is : " + iOException.getMessage());
                }
            }
        } else {
            log.warn("URLInputSynapse: provided URL contains no data");
        }
    }
}

