/*
 * Decompiled with CFR 0.152.
 */
package org.joone.io;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.StringTokenizer;
import org.joone.io.PatternTokenizer;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;

public class StreamInputTokenizer
implements PatternTokenizer {
    private static final ILogger log = LoggerFactory.getLogger(StreamInputTokenizer.class);
    private static final int MAX_BUFFER_SIZE = 0x100000;
    private LineNumberReader stream;
    private StringTokenizer tokenizer = null;
    private int numTokens = 0;
    private char m_decimalPoint = (char)46;
    private String m_delim = "; \t\n\r\f";
    private double[] tokensArray;
    private int maxBufSize;

    public StreamInputTokenizer(Reader reader) throws IOException {
        this(reader, 0x100000);
    }

    public StreamInputTokenizer(Reader reader, int n) throws IOException {
        this.maxBufSize = n;
        this.stream = new LineNumberReader(reader, n);
        this.stream.mark(n);
    }

    public int getLineno() {
        return this.stream.getLineNumber();
    }

    public int getNumTokens() throws IOException {
        return this.numTokens;
    }

    public double getTokenAt(int n) throws IOException {
        if (this.tokensArray == null && !this.nextLine()) {
            log.warn("Warning during reading input stream. Requested line not found. Returning 0.");
            return 0.0;
        }
        if (this.tokensArray.length <= n) {
            int n2 = this.stream.getLineNumber();
            log.warn("Warning during reading input stream. Requested token not found in line " + n2 + ". Returning 0.");
            return 0.0;
        }
        return this.tokensArray[n];
    }

    public double[] getTokensArray() {
        if (this.tokensArray.length == 0) {
            return this.tokensArray;
        }
        return (double[])this.tokensArray.clone();
    }

    public void mark() throws IOException {
        this.stream.mark(this.maxBufSize);
    }

    public boolean nextLine() throws IOException {
        String string = this.stream.readLine();
        if (string == null) {
            return false;
        }
        this.tokenizer = new StringTokenizer(string, this.m_delim, false);
        this.numTokens = this.tokenizer.countTokens();
        if (this.tokensArray == null || this.tokensArray.length != this.numTokens) {
            this.tokensArray = new double[this.numTokens];
        }
        for (int i = 0; i < this.numTokens; ++i) {
            this.tokensArray[i] = this.nextToken(this.m_delim);
        }
        return true;
    }

    private double nextToken() throws IOException {
        return this.nextToken(null);
    }

    private double nextToken(String string) throws IOException {
        double d;
        String string2 = null;
        if (this.tokenizer == null) {
            this.nextLine();
        }
        string2 = string != null ? this.tokenizer.nextToken(string) : this.tokenizer.nextToken();
        if (this.m_decimalPoint != '.') {
            string2 = string2.replace(this.m_decimalPoint, '.');
        }
        try {
            d = Double.valueOf(string2).floatValue();
        }
        catch (NumberFormatException numberFormatException) {
            log.warn("Warning: Not numeric value at row " + this.getLineno() + ": <" + string2 + ">");
            d = 0.0;
        }
        return d;
    }

    public void resetInput() throws IOException {
        this.stream.reset();
        this.tokenizer = null;
    }

    public void setDecimalPoint(char c) {
        this.m_decimalPoint = c;
    }

    public char getDecimalPoint() {
        return this.m_decimalPoint;
    }
}

