/*
 * Decompiled with CFR 0.152.
 */
package org.joone.io;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import org.joone.engine.Monitor;
import org.joone.engine.NetErrorManager;
import org.joone.engine.Pattern;
import org.joone.engine.Synapse;
import org.joone.exception.JooneRuntimeException;
import org.joone.inspection.Inspectable;
import org.joone.inspection.implementations.InputsInspection;
import org.joone.io.InputConnector;
import org.joone.io.InputSynapse;
import org.joone.io.PatternTokenizer;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;
import org.joone.net.NetCheck;
import org.joone.util.AbstractConverterPlugIn;
import org.joone.util.CSVParser;
import org.joone.util.ConverterPlugIn;
import org.joone.util.PlugInEvent;
import org.joone.util.PlugInListener;

public abstract class StreamInputSynapse
extends Synapse
implements InputSynapse,
Inspectable {
    private static final ILogger log = LoggerFactory.getLogger(StreamInputSynapse.class);
    private int firstRow = 1;
    private int lastRow = 0;
    private int firstCol = 0;
    private int lastCol = 0;
    private String advColumnsSel = "";
    private boolean buffered = true;
    private char decimalPoint = (char)46;
    private boolean StepCounter = true;
    protected transient int[] cols;
    protected transient Vector InputVector;
    protected transient int currentRow = 0;
    protected transient PatternTokenizer tokens;
    protected transient boolean EOF = false;
    private ConverterPlugIn plugIn;
    private int maxBufSize = 0;
    private static final long serialVersionUID = -3316265583083866079L;
    private transient int startFrom = 0;
    protected List plugInListeners = new ArrayList();
    private int myFirstRow = 1;
    private int myLastRow = 0;
    private transient boolean skipNewCycle = false;

    protected void backward(double[] dArray) {
    }

    protected void forward(double[] dArray) {
        this.outs = dArray;
    }

    public synchronized Pattern fwdGet() {
        int n;
        if (!this.isEnabled()) {
            return null;
        }
        Monitor monitor = this.getMonitor();
        if (this.EOF || this.outs == null) {
            try {
                if (this.EOF && monitor != null && this.isStepCounter()) {
                    monitor.resetCycle();
                }
                this.gotoFirstLine();
                this.outs = new double[1];
            }
            catch (Exception exception) {
                this.handleExceptionWithError(exception, "Exception while executing the \"fwdGet\".");
                return this.zeroPattern();
            }
        }
        if (this.currentRow - this.firstRow > monitor.getNumOfPatterns() - 1) {
            try {
                this.gotoFirstLine();
            }
            catch (Exception exception) {
                this.handleExceptionWithError(exception, "Exception while attempting to access the first line.");
                return this.zeroPattern();
            }
        }
        if (this.isStepCounter() && (n = monitor.nextStep()) == 0) {
            this.reset();
            return this.zeroPattern();
        }
        if (this.isBuffered()) {
            Serializable serializable;
            n = this.currentRow - this.firstRow + (this.startFrom == 0 ? 0 : this.startFrom - 1);
            if (this.getInputVector().isEmpty()) {
                this.readAll();
            } else {
                serializable = this.getPlugIn();
                if (this.currentRow == this.firstRow && serializable != null && !this.skipNewCycle) {
                    ((AbstractConverterPlugIn)serializable).setInputVector(this.getInputVector());
                    if (((ConverterPlugIn)serializable).newCycle()) {
                        this.fireDataChanged();
                    }
                }
            }
            serializable = this.getInputVector();
            int n2 = ((Vector)serializable).size();
            if (n < n2) {
                this.m_pattern = (Pattern)((Vector)serializable).elementAt(n);
            }
            if (n + 1 >= n2) {
                this.EOF = true;
            }
            ++this.currentRow;
            this.setEofOnEofCondition();
        } else {
            try {
                this.m_pattern = this.getStream();
            }
            catch (Exception exception) {
                this.handleExceptionWithError(exception, "Exception");
                exception.printStackTrace();
                return this.zeroPattern();
            }
        }
        this.m_pattern.setCount(this.currentRow - this.firstRow);
        return this.m_pattern;
    }

    public char getDecimalPoint() {
        return this.decimalPoint;
    }

    public int getFirstRow() {
        return this.firstRow;
    }

    protected Vector getInputVector() {
        if (this.InputVector == null) {
            this.InputVector = new Vector();
        }
        return this.InputVector;
    }

    private void setInputVector(Vector vector) {
        this.InputVector = vector;
    }

    public int getLastRow() {
        return this.lastRow;
    }

    protected Pattern getStream() throws IOException {
        boolean bl = this.EOF = !this.tokens.nextLine();
        if (this.EOF) {
            return null;
        }
        if (this.cols == null) {
            this.setColList();
        }
        if (this.cols == null) {
            return null;
        }
        this.inps = new double[this.cols.length];
        for (int i = 0; i < this.cols.length; ++i) {
            this.inps[i] = this.tokens.getTokenAt(this.cols[i] - 1);
        }
        ++this.currentRow;
        this.setEofOnEofCondition();
        this.forward(this.inps);
        this.m_pattern = new Pattern(this.outs);
        this.m_pattern.setCount(this.currentRow - this.firstRow);
        return this.m_pattern;
    }

    private void setEofOnEofCondition() {
        if (this.lastRow > 0 && this.currentRow > this.lastRow) {
            this.EOF = true;
        }
    }

    public void gotoFirstLine() throws IOException {
        this.gotoLine(this.firstRow);
    }

    public void gotoLine(int n) throws IOException {
        PatternTokenizer patternTokenizer;
        this.EOF = false;
        if ((!this.isBuffered() || this.getInputVector().isEmpty()) && (patternTokenizer = this.getTokens()) != null) {
            if (this.isBuffered()) {
                patternTokenizer.resetInput();
            } else {
                this.initInputStream();
            }
            this.EOF = false;
            this.currentRow = 1;
            while (this.currentRow < n && !this.EOF) {
                if (this.tokens.nextLine()) {
                    ++this.currentRow;
                    continue;
                }
                this.EOF = true;
            }
        }
        this.currentRow = n;
        this.EOF = this.lastRow > 0 && this.currentRow >= this.lastRow;
    }

    public boolean isBuffered() {
        return this.buffered;
    }

    public boolean isEOF() {
        return this.EOF;
    }

    public boolean isStepCounter() {
        if (this.getMonitor() != null && this.getMonitor().isSingleThreadMode()) {
            return false;
        }
        return this.StepCounter;
    }

    public int numColumns() {
        if (this.cols == null) {
            this.setColList();
        }
        if (this.cols == null) {
            return 0;
        }
        return this.cols.length;
    }

    public void readAll() {
        this.getInputVector().removeAllElements();
        try {
            ConverterPlugIn converterPlugIn;
            this.gotoFirstLine();
            Pattern pattern = this.getStream();
            while (pattern != null) {
                this.InputVector.addElement(pattern);
                if (this.EOF) break;
                pattern = this.getStream();
            }
            if ((converterPlugIn = this.getPlugIn()) != null) {
                converterPlugIn.setInputVector(this.InputVector);
                converterPlugIn.convertPatterns();
            }
            this.gotoFirstLine();
        }
        catch (IOException iOException) {
            this.handleExceptionWithWarn(iOException, "IOException");
        }
        catch (NumberFormatException numberFormatException) {
            this.handleExceptionWithWarn(numberFormatException, "NumberFormatException");
        }
    }

    public synchronized void revPut(Pattern pattern) {
    }

    protected void setArrays(int n, int n2) {
    }

    public void setBuffered(boolean bl) {
        if (this.plugIn == null) {
            this.buffered = bl;
        } else if (!bl) {
            log.warn("Synapse is connected to plugin so that it has to be buffered. Ignoring setBuffered(false).");
            this.buffered = true;
        }
    }

    protected void setColList() {
        if (this.getAdvancedColumnSelector().trim().length() > 0) {
            CSVParser cSVParser = new CSVParser(this.getAdvancedColumnSelector().trim());
            try {
                this.cols = cSVParser.parseInt();
            }
            catch (NumberFormatException numberFormatException) {
                new NetErrorManager(this.getMonitor(), numberFormatException.getMessage());
            }
        } else {
            if (this.getFirstCol() == 0 || this.getLastCol() == 0) {
                return;
            }
            this.cols = new int[this.getLastCol() - this.getFirstCol() + 1];
            for (int i = this.getFirstCol(); i <= this.getLastCol(); ++i) {
                this.cols[i - this.getFirstCol()] = i;
            }
        }
    }

    public void setDecimalPoint(char c) {
        this.decimalPoint = c;
        if (this.tokens != null) {
            this.tokens.setDecimalPoint(c);
        }
    }

    protected void setDimensions(int n, int n2) {
    }

    protected void setEOF(boolean bl) {
        this.EOF = bl;
    }

    public void setFirstRow(int n) {
        this.myFirstRow = this.firstRow;
        if (this.firstRow != n) {
            this.firstRow = n;
            this.resetInput();
        }
    }

    public synchronized void resetInput() {
        this.restart();
        this.tokens = null;
        this.notifyAll();
    }

    private void restart() {
        this.getInputVector().removeAllElements();
        this.EOF = false;
        this.cols = null;
    }

    public void setLastRow(int n) {
        this.myLastRow = this.lastRow;
        if (this.lastRow != n) {
            this.lastRow = n;
            this.resetInput();
        }
    }

    public boolean addPlugIn(ConverterPlugIn converterPlugIn) {
        if (this.plugIn == converterPlugIn) {
            log.warn("Plugin already connected to plugin stack. Ignoring request.");
            return false;
        }
        if (converterPlugIn == null) {
            if (this.plugIn != null) {
                this.plugIn.setConnected(false);
            }
            this.plugIn = null;
            this.resetInput();
            return true;
        }
        if (converterPlugIn.isConnected()) {
            log.warn("Plugin already connected. Ignoring request.");
            return false;
        }
        if (this.plugIn == null) {
            converterPlugIn.setConnected(true);
            converterPlugIn.addPlugInListener(this);
            if (!this.isBuffered()) {
                log.warn("Use of plugins requires buffering. Enabling. ");
            }
            this.setBuffered(true);
            this.plugIn = converterPlugIn;
            this.resetInput();
            return true;
        }
        return this.plugIn.addPlugIn(converterPlugIn);
    }

    public void removeAllPlugIns() {
        if (this.plugIn != null) {
            this.plugIn.setConnected(false);
            this.plugIn.removeAllPlugIns();
            this.plugIn = null;
        }
    }

    public boolean setPlugin(ConverterPlugIn converterPlugIn) {
        if (converterPlugIn == this.plugIn) {
            return false;
        }
        if (converterPlugIn == null) {
            this.plugIn.setConnected(false);
        } else {
            if (converterPlugIn.isConnected()) {
                return false;
            }
            converterPlugIn.setConnected(true);
            converterPlugIn.addPlugInListener(this);
            this.buffered = true;
        }
        this.plugIn = converterPlugIn;
        this.resetInput();
        return true;
    }

    public ConverterPlugIn getPlugIn() {
        return this.plugIn;
    }

    public void setPlugIn(ConverterPlugIn converterPlugIn) {
        this.setPlugin(converterPlugIn);
    }

    public void setStepCounter(boolean bl) {
        this.StepCounter = bl;
    }

    protected void writeObjectBase(ObjectOutputStream objectOutputStream) throws IOException {
        int n = 0;
        if (this.isBuffered() && (n = this.getInputVector().size()) == 0 && this.tokens != null) {
            this.gotoFirstLine();
            this.readAll();
        }
        if (objectOutputStream.getClass().getName().indexOf("xstream") != -1) {
            objectOutputStream.defaultWriteObject();
            if (this.isBuffered()) {
                objectOutputStream.writeObject(this.InputVector);
            }
        } else {
            objectOutputStream.defaultWriteObject();
            if (this.isBuffered()) {
                n = this.getInputVector().size();
                objectOutputStream.writeInt(n);
                for (int i = 0; i < n; ++i) {
                    objectOutputStream.writeObject(this.InputVector.elementAt(i));
                }
            }
        }
    }

    protected void readObjectBase(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (objectInputStream.getClass().getName().indexOf("xstream") != -1) {
            if (this.isBuffered()) {
                this.setInputVector((Vector)objectInputStream.readObject());
            }
        } else if (this.isBuffered()) {
            Vector vector = this.getInputVector();
            vector.removeAllElements();
            int n = objectInputStream.readInt();
            for (int i = 0; i < n; ++i) {
                Pattern pattern = (Pattern)objectInputStream.readObject();
                vector.addElement(pattern);
            }
        }
        if (this.advColumnsSel == null) {
            this.advColumnsSel = "";
        }
        if (this.plugInListeners == null) {
            this.plugInListeners = new ArrayList();
        }
    }

    public int getLastCol() {
        return this.lastCol;
    }

    public void setLastCol(int n) throws IllegalArgumentException {
        if (this.lastCol != n) {
            this.lastCol = n;
            this.cols = null;
        }
    }

    public int getFirstCol() {
        return this.firstCol;
    }

    public void setFirstCol(int n) throws IllegalArgumentException {
        if (this.firstCol != n) {
            this.firstCol = n;
            this.cols = null;
        }
    }

    public String getAdvancedColumnSelector() {
        return this.advColumnsSel;
    }

    public void setAdvancedColumnSelector(String string) {
        if (this.advColumnsSel.compareTo(string) != 0) {
            this.advColumnsSel = string;
            this.resetInput();
        }
    }

    public void dataChanged(PlugInEvent plugInEvent) {
        this.resetInput();
    }

    protected PatternTokenizer getTokens() throws JooneRuntimeException {
        if (this.tokens == null) {
            this.initInputStream();
        }
        return this.tokens;
    }

    protected void setTokens(PatternTokenizer patternTokenizer) {
        this.tokens = patternTokenizer;
        if (this.tokens != null) {
            this.tokens.setDecimalPoint(this.getDecimalPoint());
        }
        this.restart();
    }

    protected Pattern zeroPattern() {
        Pattern pattern = Pattern.makeStopPattern(this.getOutputDimension());
        return pattern;
    }

    protected abstract void initInputStream() throws JooneRuntimeException;

    public TreeSet check() {
        TreeSet treeSet = super.check();
        if (this.firstRow <= 0) {
            treeSet.add(new NetCheck(0, "First Row parameter cannot be less than 1.", this));
        }
        if (this.advColumnsSel == null || this.advColumnsSel.trim().length() == 0) {
            treeSet.add(new NetCheck(0, "Columns selector not set.", this));
        }
        if (this.isBuffered() && this.getInputVector().isEmpty()) {
            try {
                this.getTokens();
            }
            catch (JooneRuntimeException jooneRuntimeException) {
                treeSet.add(new NetCheck(0, "Cannot initialize the input stream: " + jooneRuntimeException.getMessage(), this));
            }
        }
        if (this.getPlugIn() != null) {
            if (!this.isBuffered()) {
                treeSet.add(new NetCheck(0, "Synapse has some plugins connected but it is not buffered", this));
            }
            this.getPlugIn().check(treeSet);
        }
        return treeSet;
    }

    public Collection Inspections() {
        ArrayList<InputsInspection> arrayList = new ArrayList<InputsInspection>();
        if (this.isBuffered()) {
            if (this.getInputVector().isEmpty() && this.getTokens() != null) {
                this.readAll();
            }
            arrayList.add(new InputsInspection(this.getInputVector()));
        } else {
            arrayList.add(new InputsInspection(null));
        }
        return arrayList;
    }

    public String InspectableTitle() {
        return this.getName();
    }

    public void reset() {
        super.reset();
        this.outs = null;
    }

    public int getMaxBufSize() {
        return this.maxBufSize;
    }

    public void setMaxBufSize(int n) {
        this.maxBufSize = n;
    }

    public Vector getInputPatterns() {
        return this.InputVector;
    }

    public void setInputPatterns(Vector vector) {
        this.InputVector = vector;
    }

    public synchronized Pattern fwdGet(InputConnector inputConnector) {
        if (this.isBuffered() && this.getInputVector().size() == 0) {
            this.firstRow = this.myFirstRow;
            this.lastRow = this.myLastRow;
            this.startFrom = 0;
            this.skipNewCycle = false;
            this.readAll();
        }
        if (inputConnector == null) {
            return null;
        }
        this.skipNewCycle = !inputConnector.isStepCounter();
        this.firstRow = inputConnector.getFirstRow();
        this.lastRow = inputConnector.getLastRow();
        this.EOF = inputConnector.isEOF();
        this.currentRow = inputConnector.getCurrentRow();
        this.startFrom = this.firstRow;
        Pattern pattern = this.fwdGet();
        this.firstRow = this.myFirstRow;
        this.lastRow = this.myLastRow;
        this.startFrom = 0;
        return pattern;
    }

    public int getCurrentRow() {
        return this.currentRow;
    }

    public void addPlugInListener(PlugInListener plugInListener) {
        if (!this.plugInListeners.contains(plugInListener)) {
            this.plugInListeners.add(plugInListener);
        }
    }

    public void removePlugInListener(PlugInListener plugInListener) {
        this.plugInListeners.remove(plugInListener);
    }

    public List getAllPlugInListeners() {
        return this.plugInListeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireDataChanged() {
        Object[] objectArray;
        StreamInputSynapse streamInputSynapse = this;
        synchronized (streamInputSynapse) {
            objectArray = this.getAllPlugInListeners().toArray();
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] == null) continue;
            ((PlugInListener)objectArray[i]).dataChanged(new PlugInEvent(this));
        }
    }

    private void handleExceptionWithWarn(Exception exception, String string) {
        this.handleExceptionWithWarn(exception, string, log);
    }

    protected void handleExceptionWithWarn(Exception exception, String string, ILogger iLogger) {
        String string2 = string + " in " + this.getSynapseNameSafely() + ". Message is : " + exception.getMessage();
        iLogger.warn(string2, exception);
        if (this.getMonitor() != null) {
            new NetErrorManager(this.getMonitor(), string2);
        }
    }

    private void handleExceptionWithError(Exception exception, String string) {
        this.handleExceptionWithError(exception, string, log);
    }

    protected void handleExceptionWithError(Exception exception, String string, ILogger iLogger) {
        String string2 = string + " in " + this.getSynapseNameSafely() + ". Message is : " + exception.getMessage();
        iLogger.error(string2, exception);
        if (this.getMonitor() != null) {
            new NetErrorManager(this.getMonitor(), string2);
        }
    }
}

