/*
 * Decompiled with CFR 0.152.
 */
package org.joone.io;

import java.io.IOException;
import org.joone.engine.Pattern;
import org.joone.io.InputConnector;
import org.joone.io.InputSwitchSynapse;
import org.joone.io.StreamInputSynapse;

public class MultipleInputSynapse
extends InputSwitchSynapse {
    private int currentInput = 0;
    private int currentPatt = 0;

    public Pattern fwdGet() {
        super.setActiveSynapse((StreamInputSynapse)this.inputs.get(this.currentInput));
        Pattern pattern = super.fwdGet();
        return this.elaboratePattern(pattern);
    }

    public Pattern fwdGet(InputConnector inputConnector) {
        StreamInputSynapse streamInputSynapse = null;
        int n = inputConnector.getFirstRow();
        int n2 = inputConnector.getCurrentRow();
        int n3 = inputConnector.getLastRow();
        for (int i = 0; i < this.inputs.size(); ++i) {
            streamInputSynapse = (StreamInputSynapse)this.inputs.elementAt(i);
            int n4 = this.getNumberOfPatterns(streamInputSynapse);
            if (n > n4) {
                n -= n4;
                n2 -= n4;
                if (n3 <= 0) continue;
                n3 -= n4;
                continue;
            }
            if (n2 > n4) {
                n = 1;
                n2 -= n4;
                if (n3 <= 0) continue;
                n3 -= n4;
                continue;
            }
            if (n3 > n4) {
                n3 = 0;
            }
            InputConnector inputConnector2 = new InputConnector();
            inputConnector2.setFirstRow(n);
            inputConnector2.setCurrentRow(n2);
            inputConnector2.setLastRow(n3);
            this.setActiveSynapse(streamInputSynapse);
            Pattern pattern = super.fwdGet(inputConnector2);
            if (!pattern.isMarkedAsStoppingPattern()) {
                pattern.setCount(inputConnector.getCurrentRow() - inputConnector.getFirstRow());
            }
            return pattern;
        }
        return null;
    }

    protected int getNumberOfPatterns(StreamInputSynapse streamInputSynapse) {
        if (streamInputSynapse.getLastRow() != 0) {
            return streamInputSynapse.getLastRow() - streamInputSynapse.getFirstRow() + 1;
        }
        if (streamInputSynapse.getInputVector().size() != 0) {
            return streamInputSynapse.getInputVector().size();
        }
        if (!streamInputSynapse.isBuffered()) {
            streamInputSynapse.setBuffered(true);
        }
        streamInputSynapse.readAll();
        return streamInputSynapse.getInputVector().size();
    }

    private Pattern elaboratePattern(Pattern pattern) {
        int n = pattern.getCount();
        if (pattern.isMarkedAsStoppingPattern()) {
            this.currentPatt = 0;
            this.currentInput = 0;
        } else {
            pattern.setCount(++this.currentPatt);
            if (this.getActiveSynapse().isEOF()) {
                ++this.currentInput;
                if (this.currentInput == this.inputs.size()) {
                    this.currentPatt = 0;
                    this.currentInput = 0;
                }
            }
        }
        return pattern;
    }

    public void reset() {
        super.reset();
        this.currentPatt = 0;
        this.currentInput = 0;
    }

    public void setBuffered(boolean bl) {
        for (int i = 0; i < this.inputs.size(); ++i) {
            StreamInputSynapse streamInputSynapse = (StreamInputSynapse)this.inputs.elementAt(i);
            streamInputSynapse.setBuffered(bl);
        }
    }

    public void gotoLine(int n) throws IOException {
        StreamInputSynapse streamInputSynapse = null;
        for (int i = 0; i < this.inputs.size(); ++i) {
            streamInputSynapse = (StreamInputSynapse)this.inputs.elementAt(i);
            int n2 = this.getNumberOfPatterns(streamInputSynapse);
            if (n < n2 + streamInputSynapse.getFirstRow() - 1) {
                this.setActiveSynapse(streamInputSynapse);
                streamInputSynapse.gotoLine(n);
                return;
            }
            n -= n2;
        }
    }

    public void setFirstRow(int n) {
        throw new UnsupportedOperationException("Control the first row through the underlying source or any connected input connectors");
    }

    public void setLastRow(int n) {
        throw new UnsupportedOperationException("Control the last row through the underlying source or any connected input connectors");
    }
}

