/*
 * Decompiled with CFR 0.152.
 */
package org.joone.io;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.TreeSet;
import org.joone.engine.NetErrorManager;
import org.joone.exception.JooneRuntimeException;
import org.joone.io.StreamInputSynapse;
import org.joone.io.StreamInputTokenizer;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;
import org.joone.net.NetCheck;

public class JDBCInputSynapse
extends StreamInputSynapse {
    private static final ILogger log = LoggerFactory.getLogger(JDBCInputSynapse.class);
    private String driverName = "";
    private String dbURL = "";
    private String SQLQuery = "";
    private static final long serialVersionUID = -4642657913289986240L;

    public JDBCInputSynapse() {
    }

    public JDBCInputSynapse(String string, String string2, String string3, String string4, int n, int n2, boolean bl) {
        this.setBuffered(bl);
        this.setFirstRow(n);
        this.setLastRow(n2);
        this.setAdvancedColumnSelector(string4);
        this.driverName = string;
        this.dbURL = string2;
        this.SQLQuery = string3;
        this.resetInputAndTokens();
    }

    public String getdriverName() {
        return this.driverName;
    }

    public String getdbURL() {
        return this.dbURL;
    }

    public String getSQLQuery() {
        return this.SQLQuery;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        super.readObjectBase(objectInputStream);
        if (objectInputStream.getClass().getName().indexOf("xstream") == -1) {
            this.driverName = (String)objectInputStream.readObject();
            this.dbURL = (String)objectInputStream.readObject();
            this.SQLQuery = (String)objectInputStream.readObject();
        }
        if (!this.isBuffered() || this.getInputVector().size() == 0) {
            this.setdriverName(this.driverName);
        }
    }

    public void setdriverName(String string) {
        if (!string.equals(this.driverName)) {
            this.driverName = string;
            this.resetInputAndTokens();
        }
    }

    private void resetInputAndTokens() {
        this.resetInput();
        this.setTokens(null);
    }

    public void setdbURL(String string) {
        if (!this.dbURL.equals(string)) {
            this.dbURL = string;
            this.resetInputAndTokens();
        }
    }

    public void setSQLQuery(String string) {
        if (!this.SQLQuery.equals(string)) {
            this.SQLQuery = string;
            this.resetInputAndTokens();
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        super.writeObjectBase(objectOutputStream);
        if (objectOutputStream.getClass().getName().indexOf("xstream") == -1) {
            objectOutputStream.writeObject(this.driverName);
            objectOutputStream.writeObject(this.dbURL);
            objectOutputStream.writeObject(this.SQLQuery);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initInputStream() throws JooneRuntimeException {
        if (!this.checkIfPropertiesSet()) {
            return;
        }
        try {
            Class.forName(this.driverName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            String string = "Could not find Database Driver Class while initializing the JDBCInputStream";
            this.handleExceptionWithError(classNotFoundException, string, log);
            return;
        }
        Statement statement = null;
        ResultSet resultSet = null;
        Connection connection = null;
        try {
            try {
                connection = DriverManager.getConnection(this.dbURL);
                try {
                    statement = connection.createStatement();
                    try {
                        resultSet = statement.executeQuery(this.SQLQuery);
                        this.tokenizeResultSet(resultSet);
                    }
                    finally {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                }
                finally {
                    if (statement != null) {
                        statement.close();
                    }
                }
            }
            finally {
                if (connection != null) {
                    connection.close();
                }
            }
        }
        catch (SQLException sQLException) {
            String string = "SQLException thrown while initializing the JDBCInputStream";
            this.handleExceptionWithError(sQLException, string, log);
        }
        catch (IOException iOException) {
            String string = "IOException thrown while initializing the JDBCInputStream";
            this.handleExceptionWithError(iOException, string, log);
        }
    }

    private boolean checkIfPropertiesSet() {
        if (this.isStringEmpty(this.driverName)) {
            this.handlePropertyNotSet("The Driver Name has not been entered or is empty");
            return false;
        }
        if (this.isStringEmpty(this.dbURL)) {
            this.handlePropertyNotSet("The Database URL has not been entered or is empty");
            return false;
        }
        if (this.isStringEmpty(this.SQLQuery)) {
            this.handlePropertyNotSet("The SQL Query has not been entered or is empty");
            return false;
        }
        return true;
    }

    private void handlePropertyNotSet(String string) {
        String string2 = string + " in " + this.getSynapseNameSafely() + ".";
        log.warn(string2);
        if (this.getMonitor() != null) {
            new NetErrorManager(this.getMonitor(), string2);
        }
    }

    private void tokenizeResultSet(ResultSet resultSet) throws SQLException, IOException {
        StringBuffer stringBuffer = new StringBuffer();
        while (resultSet.next()) {
            if (resultSet.getMetaData().getColumnCount() >= 1) {
                stringBuffer.append(resultSet.getDouble(1));
            }
            for (int i = 2; i <= resultSet.getMetaData().getColumnCount(); ++i) {
                stringBuffer.append(";");
                stringBuffer.append(resultSet.getDouble(i));
            }
            stringBuffer.append('\n');
        }
        StreamInputTokenizer streamInputTokenizer = this.getMaxBufSize() > 0 ? new StreamInputTokenizer(new StringReader(stringBuffer.toString()), this.getMaxBufSize()) : new StreamInputTokenizer(new StringReader(stringBuffer.toString()));
        super.setTokens(streamInputTokenizer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TreeSet check() {
        TreeSet treeSet;
        block11: {
            treeSet = super.check();
            Connection connection = null;
            if (this.isStringEmpty(this.driverName)) {
                this.addNetCheckFatal(treeSet, "Database Driver Name needs to be entered.");
            } else {
                try {
                    Class.forName(this.driverName);
                    if (this.isStringEmpty(this.dbURL)) break block11;
                    try {
                        connection = DriverManager.getConnection(this.dbURL);
                    }
                    finally {
                        if (connection != null && !connection.isClosed()) {
                            connection.close();
                        }
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.addNetCheckFatal(treeSet, "Could not find Database Driver Class. Check Database Driver is in the classpath and is readable.");
                }
                catch (SQLException sQLException) {
                    this.addNetCheckFatal(treeSet, "The Database URL is incorrect. Connection error is : " + sQLException.toString());
                }
            }
        }
        if (this.isStringEmpty(this.dbURL)) {
            this.addNetCheckFatal(treeSet, "Database URL needs to be entered.");
        }
        if (this.isStringEmpty(this.SQLQuery)) {
            this.addNetCheckFatal(treeSet, "Database SQL Query needs to be entered.");
        }
        return treeSet;
    }

    private boolean isStringEmpty(String string) {
        return string == null || string.trim().equals("");
    }

    private void addNetCheckFatal(TreeSet treeSet, String string) {
        treeSet.add(new NetCheck(0, string, this));
    }
}

