/*
 * Decompiled with CFR 0.152.
 */
package org.joone.io;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.TreeSet;
import java.util.Vector;
import org.joone.engine.Monitor;
import org.joone.engine.Pattern;
import org.joone.io.InputConnector;
import org.joone.io.StreamInputSynapse;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;
import org.joone.util.ConverterPlugIn;
import org.joone.util.PlugInEvent;

public class InputSwitchSynapse
extends StreamInputSynapse
implements Serializable {
    protected Vector inputs;
    private StreamInputSynapse activeSynapse;
    private StreamInputSynapse defaultSynapse;
    private String name;
    private Monitor mon;
    private int outputDimension;
    private static final long serialVersionUID = 9025876263540714672L;
    private static final ILogger log = LoggerFactory.getLogger(InputSwitchSynapse.class);

    public InputSwitchSynapse() {
        this.initSwitch();
        this.mon = null;
        this.outputDimension = 0;
    }

    private void initSwitch() {
        this.inputs = new Vector();
        this.defaultSynapse = null;
        this.activeSynapse = null;
    }

    public void init() {
        super.init();
        for (int i = 0; i < this.inputs.size(); ++i) {
            StreamInputSynapse streamInputSynapse = (StreamInputSynapse)this.inputs.elementAt(i);
            streamInputSynapse.init();
        }
    }

    public void resetSwitch() {
        this.setActiveSynapse(this.getDefaultSynapse());
    }

    public void reset() {
        for (int i = 0; i < this.inputs.size(); ++i) {
            StreamInputSynapse streamInputSynapse = (StreamInputSynapse)this.inputs.elementAt(i);
            streamInputSynapse.reset();
        }
    }

    public boolean removeInputSynapse(String string) {
        StreamInputSynapse streamInputSynapse = this.getInputSynapse(string);
        if (streamInputSynapse == null) {
            String string2 = string == null ? "" : string;
            log.warn("Synapse [" + string2 + "] not registered in switch. Ignoring removal request.");
            return false;
        }
        this.inputs.removeElement(streamInputSynapse);
        streamInputSynapse.setInputFull(false);
        if (this.inputs.isEmpty()) {
            this.setActiveInput("");
            this.setDefaultInput("");
        } else {
            if (this.getActiveInput().equalsIgnoreCase(string)) {
                this.setActiveSynapse((StreamInputSynapse)this.inputs.elementAt(0));
            }
            if (this.getDefaultInput().equalsIgnoreCase(string)) {
                this.setDefaultSynapse((StreamInputSynapse)this.inputs.elementAt(0));
            }
        }
        return true;
    }

    protected StreamInputSynapse getInputSynapse(String string) {
        for (int i = 0; i < this.inputs.size(); ++i) {
            StreamInputSynapse streamInputSynapse = (StreamInputSynapse)this.inputs.elementAt(i);
            if (!streamInputSynapse.getName().equalsIgnoreCase(string)) continue;
            return streamInputSynapse;
        }
        return null;
    }

    public boolean addInputSynapse(StreamInputSynapse streamInputSynapse) {
        if (streamInputSynapse == null) {
            log.warn("Null input synapse provided. Ignoring.");
            return false;
        }
        if (this.inputs.contains(streamInputSynapse)) {
            log.warn("Synapse already registered in switch. Ignoring.");
            return false;
        }
        if (streamInputSynapse.isInputFull()) {
            log.warn("Provided synapse is already connected. Ignoring.");
            return false;
        }
        this.inputs.addElement(streamInputSynapse);
        streamInputSynapse.setOutputDimension(this.outputDimension);
        streamInputSynapse.setMonitor(this.mon);
        streamInputSynapse.setStepCounter(super.isStepCounter());
        streamInputSynapse.setInputFull(true);
        if (this.inputs.size() == 1) {
            this.setDefaultInput(streamInputSynapse.getName());
            this.setActiveInput(streamInputSynapse.getName());
        }
        return true;
    }

    public String getActiveInput() {
        if (this.activeSynapse == null) {
            return "";
        }
        return this.activeSynapse.getName();
    }

    public void setActiveInput(String string) {
        StreamInputSynapse streamInputSynapse = this.getInputSynapse(string);
        if (streamInputSynapse == null) {
            String string2 = string == null ? "" : string;
            log.warn("Synapse [" + string2 + "] not registered in switch. Setting active synapse to empty value.");
        }
        this.activeSynapse = streamInputSynapse;
    }

    public String getDefaultInput() {
        if (this.defaultSynapse == null) {
            return "";
        }
        return this.defaultSynapse.getName();
    }

    public void setDefaultInput(String string) {
        StreamInputSynapse streamInputSynapse = this.getInputSynapse(string);
        if (streamInputSynapse == null) {
            String string2 = string == null ? "" : string;
            log.warn("Synapse [" + string2 + "] not registered in switch. Setting default synapse to empty value.");
        }
        this.defaultSynapse = streamInputSynapse;
    }

    protected StreamInputSynapse getActiveSynapse() {
        return this.activeSynapse;
    }

    protected void setActiveSynapse(StreamInputSynapse streamInputSynapse) {
        this.activeSynapse = streamInputSynapse;
    }

    protected StreamInputSynapse getDefaultSynapse() {
        return this.defaultSynapse;
    }

    protected void setDefaultSynapse(StreamInputSynapse streamInputSynapse) {
        this.defaultSynapse = streamInputSynapse;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setOutputDimension(int n) {
        this.outputDimension = n;
        for (int i = 0; i < this.inputs.size(); ++i) {
            StreamInputSynapse streamInputSynapse = (StreamInputSynapse)this.inputs.elementAt(i);
            streamInputSynapse.setOutputDimension(n);
        }
    }

    public void revPut(Pattern pattern) {
        if (this.activeSynapse == null) {
            log.warn("Active synapse not set");
        } else {
            this.activeSynapse.revPut(pattern);
        }
    }

    public Pattern fwdGet() {
        if (this.activeSynapse == null) {
            log.warn("Active synapse not set");
            return null;
        }
        return this.activeSynapse.fwdGet();
    }

    public Pattern fwdGet(InputConnector inputConnector) {
        if (this.activeSynapse == null) {
            log.warn("Active synapse not set");
            return null;
        }
        return this.activeSynapse.fwdGet(inputConnector);
    }

    public int getOutputDimension() {
        return this.outputDimension;
    }

    public Monitor getMonitor() {
        return this.mon;
    }

    public void setMonitor(Monitor monitor) {
        this.mon = monitor;
        for (int i = 0; i < this.inputs.size(); ++i) {
            StreamInputSynapse streamInputSynapse = (StreamInputSynapse)this.inputs.elementAt(i);
            streamInputSynapse.setMonitor(monitor);
        }
    }

    protected void backward(double[] dArray) {
    }

    protected void forward(double[] dArray) {
    }

    public Vector getAllInputs() {
        return this.inputs;
    }

    public void setAllInputs(Vector vector) {
        this.inputs = vector;
        if (this.inputs != null) {
            for (int i = 0; i < this.inputs.size(); ++i) {
                StreamInputSynapse streamInputSynapse = (StreamInputSynapse)this.inputs.elementAt(i);
                streamInputSynapse.setInputFull(true);
            }
        }
    }

    public void resetInput() {
        for (int i = 0; i < this.inputs.size(); ++i) {
            StreamInputSynapse streamInputSynapse = (StreamInputSynapse)this.inputs.elementAt(i);
            streamInputSynapse.resetInput();
        }
        this.reset();
    }

    protected void initInputStream() {
    }

    public void setStepCounter(boolean bl) {
        super.setStepCounter(bl);
        for (int i = 0; i < this.inputs.size(); ++i) {
            StreamInputSynapse streamInputSynapse = (StreamInputSynapse)this.inputs.elementAt(i);
            streamInputSynapse.setStepCounter(bl);
        }
    }

    public void gotoLine(int n) throws IOException {
        if (this.activeSynapse != null) {
            this.activeSynapse.gotoLine(n);
        }
    }

    public void dataChanged(PlugInEvent plugInEvent) {
    }

    public void setDecimalPoint(char c) {
        if (this.activeSynapse != null) {
            this.activeSynapse.setDecimalPoint(c);
        }
    }

    public boolean isEOF() {
        if (this.activeSynapse != null) {
            return this.activeSynapse.isEOF();
        }
        return false;
    }

    public void readAll() {
        if (this.activeSynapse != null) {
            this.activeSynapse.readAll();
        }
    }

    public void setBuffered(boolean bl) {
        if (this.activeSynapse != null) {
            this.activeSynapse.setBuffered(bl);
        }
    }

    public boolean isBuffered() {
        if (this.activeSynapse != null) {
            return this.activeSynapse.isBuffered();
        }
        return false;
    }

    public ConverterPlugIn getPlugIn() {
        if (this.activeSynapse != null) {
            return this.activeSynapse.getPlugIn();
        }
        return null;
    }

    public boolean isStepCounter() {
        if (this.activeSynapse != null) {
            return this.activeSynapse.isStepCounter();
        }
        return false;
    }

    public void gotoFirstLine() throws IOException {
        if (this.activeSynapse != null) {
            this.activeSynapse.gotoFirstLine();
        }
    }

    public void removeAllInputs() {
        for (int i = 0; i < this.inputs.size(); ++i) {
            StreamInputSynapse streamInputSynapse = (StreamInputSynapse)this.inputs.elementAt(i);
            streamInputSynapse.setInputFull(false);
        }
        this.initSwitch();
    }

    public TreeSet check() {
        TreeSet treeSet = new TreeSet();
        for (int i = 0; i < this.inputs.size(); ++i) {
            StreamInputSynapse streamInputSynapse = (StreamInputSynapse)this.inputs.elementAt(i);
            treeSet.addAll(streamInputSynapse.check());
        }
        return treeSet;
    }

    public int getFirstRow() {
        if (this.activeSynapse != null) {
            return this.activeSynapse.getFirstRow();
        }
        return 0;
    }

    public int getLastRow() {
        if (this.activeSynapse != null) {
            return this.activeSynapse.getLastRow();
        }
        return 0;
    }

    public Collection getInspections() {
        if (this.activeSynapse != null) {
            return this.activeSynapse.Inspections();
        }
        return null;
    }

    public int numColumns() {
        if (this.activeSynapse != null) {
            return this.activeSynapse.numColumns();
        }
        return 0;
    }

    public String getAdvancedColumnSelector() {
        if (this.activeSynapse != null) {
            return this.activeSynapse.getAdvancedColumnSelector();
        }
        return "";
    }
}

