/*
 * Decompiled with CFR 0.152.
 */
package org.joone.io;

import java.util.TreeSet;
import org.joone.engine.Monitor;
import org.joone.engine.Pattern;
import org.joone.exception.JooneRuntimeException;
import org.joone.io.StreamInputSynapse;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;
import org.joone.net.NetCheck;
import org.joone.util.PlugInEvent;
import org.joone.util.PlugInListener;

public class InputConnector
extends StreamInputSynapse
implements PlugInListener {
    private static final ILogger log = LoggerFactory.getLogger(InputConnector.class);
    private static final long serialVersionUID = -3316265583123866079L;
    private StreamInputSynapse inputSynapse;

    public InputConnector() {
        this.setBuffered(false);
    }

    protected void initInputStream() throws JooneRuntimeException {
        this.currentRow = this.getFirstRow();
        this.EOF = false;
    }

    public boolean setInputSynapse(StreamInputSynapse streamInputSynapse) {
        if (streamInputSynapse != null) {
            streamInputSynapse.setMonitor(this.getMonitor());
            streamInputSynapse.setBuffered(true);
            streamInputSynapse.setStepCounter(false);
            streamInputSynapse.setInputFull(true);
            streamInputSynapse.addPlugInListener(this);
            this.setOutputFull(true);
        } else {
            this.setOutputFull(false);
            if (this.getInputSynapse() != null) {
                this.getInputSynapse().removePlugInListener(this);
                this.getInputSynapse().setInputFull(false);
            }
        }
        this.inputSynapse = streamInputSynapse;
        return true;
    }

    protected Pattern getStream() {
        if (this.getInputSynapse() == null) {
            return null;
        }
        Pattern pattern = this.getInputSynapse().fwdGet(this);
        if (pattern == null) {
            return null;
        }
        if (this.cols == null) {
            this.setColList();
        }
        if (this.cols == null) {
            return null;
        }
        this.inps = new double[this.cols.length];
        for (int i = 0; i < this.cols.length; ++i) {
            this.inps[i] = pattern.getArray()[this.cols[i] - 1];
        }
        ++this.currentRow;
        if (this.currentRow - this.getFirstRow() > this.getMonitor().getNumOfPatterns() - 1) {
            this.EOF = true;
        }
        if (this.getLastRow() > 0 && this.getCurrentRow() > this.getLastRow()) {
            this.EOF = true;
        }
        this.forward(this.inps);
        Pattern pattern2 = new Pattern(this.outs);
        pattern2.setCount(this.getCurrentRow() - this.getFirstRow());
        return pattern2;
    }

    public void setMonitor(Monitor monitor) {
        super.setMonitor(monitor);
        if (this.getInputSynapse() != null) {
            this.getInputSynapse().setMonitor(monitor);
        }
    }

    public void dataChanged(PlugInEvent plugInEvent) {
        if (this.isBuffered()) {
            this.getInputVector().removeAllElements();
        }
    }

    public TreeSet check() {
        TreeSet treeSet = super.check();
        if (this.getInputSynapse() == null) {
            treeSet.add(new NetCheck(0, "Input Synapse not set", this));
        } else if (!this.getInputSynapse().isBuffered()) {
            treeSet.add(new NetCheck(0, "The Input Synapse must be buffered", this));
        }
        return treeSet;
    }

    public void resetInput() {
        if (this.getInputSynapse() != null) {
            this.getInputSynapse().resetInput();
        }
    }

    protected void setCurrentRow(int n) {
        this.currentRow = n;
    }

    public StreamInputSynapse getInputSynapse() {
        return this.inputSynapse;
    }
}

