/*
 * Decompiled with CFR 0.152.
 */
package org.joone.io;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.TreeSet;
import javax.imageio.ImageIO;
import org.joone.engine.Pattern;
import org.joone.io.StreamOutputSynapse;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;
import org.joone.net.NetCheck;

public class ImageOutputSynapse
extends StreamOutputSynapse {
    private static final ILogger log = LoggerFactory.getLogger(ImageOutputSynapse.class);
    static final long serialVersionUID = 1287752494948170142L;
    public final int JPG = 1;
    public final int GIF = 2;
    public final int PNG = 3;
    private String OutputDirectory = System.getProperty("user.dir");
    private int ImageFileType = 1;
    private int Width = 10;
    private int Height = 10;
    private boolean ColourMode = true;

    public void write(Pattern pattern) {
        if (!pattern.isMarkedAsStoppingPattern()) {
            String string;
            switch (this.getImageFileType()) {
                case 1: {
                    string = "jpg";
                    break;
                }
                case 2: {
                    string = "gif";
                    break;
                }
                case 3: {
                    string = "png";
                    break;
                }
                default: {
                    string = "jpg";
                }
            }
            try {
                String string2 = this.getOutputDirectory();
                if (!string2.endsWith(System.getProperty("file.separator"))) {
                    string2 = string2 + System.getProperty("file.separator");
                }
                File file = new File(string2 + "Image" + pattern.getCount() + "." + string);
                BufferedImage bufferedImage = this.patternToImage(pattern);
                if (bufferedImage != null) {
                    ImageIO.write((RenderedImage)bufferedImage, string, file);
                }
            }
            catch (Exception exception) {
                log.error("Caught exception when trying to write Image : " + exception.toString());
            }
        }
    }

    private BufferedImage patternToImage(Pattern pattern) {
        BufferedImage bufferedImage = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        double[] dArray = pattern.getArray();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        if (this.ColourMode) {
            if (dArray.length == this.getWidth() * this.getHeight() * 3) {
                for (n7 = 0; n7 < dArray.length; n7 += 3) {
                    n = (int)(dArray[n7] * 255.0);
                    n2 = (int)(dArray[n7 + 1] * 255.0);
                    n3 = (int)(dArray[n7 + 2] * 255.0);
                    n4 = 0 + (n << 16) + (n2 << 8) + n3;
                    bufferedImage.setRGB(n5, n6, n4);
                    if (++n5 < this.getWidth()) continue;
                    n5 = 0;
                    ++n6;
                }
            } else {
                log.error("Pattern Contains " + pattern.getCount() + " RGB Values - Image Contains " + this.getWidth() * this.getHeight() + " RGB Values , Size Mismatch.");
            }
        } else if (dArray.length == this.getWidth() * this.getHeight()) {
            for (n7 = 0; n7 < dArray.length; ++n7) {
                n4 = (int)(dArray[n7] * 255.0);
                n4 = 0 + (n4 << 16) + (n4 << 8) + n4;
                bufferedImage.setRGB(n5, n6, n4);
                if (++n5 < this.getWidth()) continue;
                n5 = 0;
                ++n6;
            }
        } else {
            log.error("Pattern Contains " + pattern.getCount() + " RGB Values - Image Contains " + this.getWidth() * this.getHeight() + " RGB Values , Size Mismatch.");
        }
        return bufferedImage;
    }

    public String getOutputDirectory() {
        return this.OutputDirectory;
    }

    public void setOutputDirectory(String string) {
        this.OutputDirectory = string;
    }

    public int getImageFileType() {
        return this.ImageFileType;
    }

    public void setImageFileType(int n) {
        this.ImageFileType = n;
        if (this.ImageFileType < 1) {
            this.ImageFileType = 1;
        }
        if (this.ImageFileType > 3) {
            this.ImageFileType = 3;
        }
    }

    public int getWidth() {
        return this.Width;
    }

    public void setWidth(int n) {
        this.Width = n;
    }

    public int getHeight() {
        return this.Height;
    }

    public void setHeight(int n) {
        this.Height = n;
    }

    public boolean getColourMode() {
        return this.ColourMode;
    }

    public void setColourMode(boolean bl) {
        this.ColourMode = bl;
    }

    public TreeSet check() {
        TreeSet treeSet = super.check();
        if (this.ColourMode) {
            if (this.Width * this.Height * 3 != this.getInputDimension()) {
                treeSet.add(new NetCheck(0, "Image Width[" + this.getWidth() + "]*Height[" + this.getHeight() + "]*3 not equal to number of inputs from connected layer/s [" + this.getInputDimension() + "].", this));
            }
        } else if (this.Width * this.Height != this.getInputDimension()) {
            treeSet.add(new NetCheck(0, "Image Width[" + this.getWidth() + "]*Height[" + this.getHeight() + "] not equal to number of inputs from connected layer/s [" + this.getInputDimension() + "].", this));
        }
        if (this.OutputDirectory.equals("")) {
            treeSet.add(new NetCheck(0, "No image output directory set.", this));
        }
        return treeSet;
    }
}

