/*
 * Decompiled with CFR 0.152.
 */
package org.joone.io;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.TreeSet;
import org.joone.engine.NetErrorManager;
import org.joone.engine.Pattern;
import org.joone.io.StreamOutputSynapse;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;
import org.joone.net.NetCheck;

public class FileOutputSynapse
extends StreamOutputSynapse {
    private static final ILogger log = LoggerFactory.getLogger(FileOutputSynapse.class);
    private String FileName = "";
    private boolean append = false;
    protected transient PrintWriter printer = null;
    private static final long serialVersionUID = 3194671306693862830L;

    public synchronized void write(Pattern pattern) {
        if (this.printer == null || pattern.getCount() == 1) {
            this.setFileName(this.FileName);
        }
        if (pattern.isMarkedAsStoppingPattern()) {
            this.flush();
        } else {
            double[] dArray = pattern.getArray();
            for (int i = 0; i < dArray.length; ++i) {
                this.printer.print(dArray[i]);
                if (i >= dArray.length - 1) continue;
                this.printer.print(this.getSeparator());
            }
            this.printer.println();
        }
    }

    public String getFileName() {
        return this.FileName;
    }

    public void setFileName(String string) {
        block3: {
            this.FileName = string;
            try {
                if (this.printer != null) {
                    this.printer.close();
                }
                this.printer = new PrintWriter(new FileOutputStream(string, this.isAppend()), true);
            }
            catch (IOException iOException) {
                String string2 = "IOException in " + this.getName() + ". Message is : ";
                log.error(string2 + iOException.getMessage());
                if (this.getMonitor() == null) break block3;
                new NetErrorManager(this.getMonitor(), string2 + iOException.getMessage());
            }
        }
    }

    public void flush() {
        this.printer.flush();
        this.printer.close();
        this.printer = null;
    }

    public TreeSet check() {
        TreeSet treeSet = super.check();
        if (this.FileName == null || this.FileName.trim().equals("")) {
            treeSet.add(new NetCheck(0, "File Name not set.", this));
        }
        return treeSet;
    }

    public boolean isAppend() {
        return this.append;
    }

    public void setAppend(boolean bl) {
        this.append = bl;
    }
}

