/*
 * Decompiled with CFR 0.152.
 */
package org.joone.inspection.implementations;

import java.util.Vector;
import org.joone.engine.Pattern;
import org.joone.inspection.Inspection;

public class InputsInspection
implements Inspection {
    private Vector inputs = null;

    public InputsInspection(Vector vector) {
        this.inputs = vector;
    }

    public Object[][] getComponent() {
        if (this.inputs != null && this.inputs.size() > 0) {
            int n;
            Object[][] objectArray = null;
            for (n = 0; n < this.inputs.size(); ++n) {
                Pattern pattern = (Pattern)this.inputs.elementAt(n);
                double[] dArray = pattern.getArray();
                if (objectArray == null) {
                    objectArray = new Object[this.inputs.size()][dArray.length + 1];
                }
                for (int i = 1; i < dArray.length + 1; ++i) {
                    Double d = new Double(dArray[i - 1]);
                    objectArray[n][i] = d;
                }
            }
            for (n = 0; n < this.inputs.size(); ++n) {
                objectArray[n][0] = new Integer(n + 1);
            }
            return objectArray;
        }
        return null;
    }

    public String getTitle() {
        return "Inputs";
    }

    public Object[] getNames() {
        if (this.inputs != null && this.inputs.size() > 0) {
            String[] stringArray = null;
            for (int i = 0; i < this.inputs.size(); ++i) {
                Pattern pattern = (Pattern)this.inputs.elementAt(i);
                double[] dArray = pattern.getArray();
                if (stringArray == null) {
                    stringArray = new String[dArray.length + 1];
                }
                stringArray[0] = "Row Number";
                for (int j = 1; j < dArray.length + 1; ++j) {
                    stringArray[j] = "Column " + j;
                }
            }
            return stringArray;
        }
        return null;
    }

    public boolean rowNumbers() {
        return true;
    }

    public void setComponent(Object[][] objectArray) {
        for (int i = 0; i < this.inputs.size() && i < objectArray.length; ++i) {
            double[] dArray = ((Pattern)this.inputs.elementAt(i)).getArray();
            int n = ((Pattern)this.inputs.elementAt(i)).getCount();
            for (int j = 0; j < dArray.length && j < objectArray[0].length - 1; ++j) {
                dArray[j] = (Double)objectArray[i][j + 1];
            }
            Pattern pattern = new Pattern(dArray);
            pattern.setCount(n);
            this.inputs.setElementAt(pattern, i);
        }
    }
}

